﻿using System;
using System.Collections.Generic;
using System.Text;

namespace SlothLib.LinearAlgebra.FeatureVector
{
	/// <summary>
	/// IVectorからさらに、演算機能を実装したクラス。(T版)
	/// </summary>
	/// <remarks>
	/// 
	/// <newpara>[2007-06-13][shirasuna]作成</newpara>
	/// </remarks>
	abstract public class AbstractVector<T> : IVector<T>
	{
		/// <summary>
		/// ベクトル同士の加算を行う
		/// </summary>
		public static IVector<T> operator +(AbstractVector<T> vector1, IVector<T> vector2) {
			return VectorOperator<T>.Add(vector1, vector2);
		}

		/// <summary>
		/// ベクトル同士の減算を行う
		/// </summary>
		public static IVector<T> operator -(AbstractVector<T> vector1, IVector<T> vector2)
		{
			return VectorOperator<T>.Subtract(vector1, vector2);
		}

		/// <summary>
		/// ベクトルを反転する
		/// </summary>
		public static IVector<T> operator -(AbstractVector<T> vector)
		{
			return VectorOperator<T>.Negate(vector);
		}

		/// <summary>
		/// ベクトルを整数倍する
		/// </summary>
		public static IVector<T> operator *(double scalar, AbstractVector<T> vector)
		{
			return VectorOperator<T>.Multiply(scalar, vector);
		}

		/// <summary>
		/// ベクトルへのアクセスを行う
		/// </summary>
		abstract public double this[T key]
		{
			get;
			set;
		}

		/// <summary>
		/// ベクトルの次元となるキー一覧
		/// </summary>
		abstract public Dictionary<T, double>.KeyCollection Keys
		{
			get;
		}

        /// <summary>
        /// ベクトル中の値が 0 でない要素の数を取得する。
        /// </summary>
        abstract public int Count
        {
            get;
        }

		/// <summary>
		/// ベクトルをdouble[]型に変換する
		/// </summary>
		public abstract double[] GetPlainVector();

		/// <summary>
		/// 複製を取得する
		/// </summary>
		public abstract object Clone();

		/// <summary>
		/// ベクトルにある要素のうち、0以外の値をもつ要素の一覧を取得する。
		/// </summary>
		public abstract T[] KeyList { get; }

		/// <summary>
		/// ソートされた要素のリスト
		/// </summary>
		/// <returns>ベクトルの重みが降順にソートされたKeyList</returns>
		public abstract T[] GetSortedKeyList();

        /// <summary>
        /// ベクトルがkeyの次元を持つかどうかを返す
        /// </summary>
        /// <param name="key">持つかどうか確かめたい次元となるkey</param>
        /// <returns>持つ場合はtrue，持たない場合はfalse</returns>
        public abstract bool ContainsKey(T key);
	}
}
