using System;
using System.Collections.Generic;
using System.Text;

namespace SlothLib.LinearAlgebra.Vector
{
	/// <summary>
	/// xNgɑ΂e퉉Z public static \bhB
	/// </summary>
	/// <remarks>
	/// 
	/// <newpara>[2007-04-25][ohshima]쐬</newpara>
	/// <newpara>[2007-05-08][shirasuna]</newpara>
    /// <newpara>[2007-11-09][kabutoya]C</newpara>
	/// </remarks>
	public class VectorOperator
	{
		#region ʋ@\

		/// <summary>
		/// 2̃xNgԂ̎rAقȂΗO𔭐B
		/// </summary>

		private static void CheckDimension(IVector vector1, IVector vector2)
		{
			if (vector1.Dimension != vector2.Dimension)
			{
				throw new ArgumentException("2̃xNg͓̎łȂĂ͂܂B");
			}
		}

		#endregion

		# region vertor -> scalar ^Z

		#region őlmiX[vmj

		/// <summary>
		/// xNg̗vf̂AΒl̍őlԂB
		/// </summary>

		public static double GetMaxNorm(IVector vector)
		{
			double d = 0.0;
			for (int i = 0; i < vector.Dimension; i++)
			{
				if (d < Math.Abs(vector[i]))
				{
					d = Math.Abs(vector[i]);
				}
			}
			return d;
		}

		#endregion

		#region p-m

		/// <summary>
		/// xNg̑SĂ̗vfp悵̘̂aA1/p悵lԂB
		/// </summary>
		/// <param name="vector">vZΏۂ̃xNg</param>
		/// <param name="p">p[^B1ȏłȂ΂ȂȂB</param>
		/// <returns></returns>

		public static double GetPNorm(IVector vector, double p)
		{
			if (p < 1)
				throw(new ArgumentException("p1傫Kv܂B"));

			double d = 0.0;
			for (int i = 0; i < vector.Dimension; i++)
			{
				d += Math.Pow(vector[i], p);
			}

			return Math.Pow(d, 1/p);
		}

		#endregion

		#region [NbhiPj

		/// <summary>
		/// _̃[NbhvZB
		/// </summary>
		/// <param name="vector"></param>
		/// <returns></returns>
		public static double GetEuclideanDistance(IVector vector)
		{
			double d = 0.0;
			for (int i = 0; i < vector.Dimension; i++)
			{
				d = d + Math.Pow(vector[i], 2.0);
			}
			return Math.Sqrt(d);
		}

		#endregion

		# endregion

		# region vector * vector -> scalar ^Z

		#region [Nbhi񍀁j

		/// <summary>
		/// 2̃xNgԂ̃[NbhvZB
		/// </summary>
		/// <param name="vector1"></param>
		/// <param name="vector2"></param>
		/// <returns></returns>
		public static double GetEuclideanDistance(IVector vector1, IVector vector2)
		{
			CheckDimension(vector1, vector2);
			double d = 0.0;
			for (int i = 0; i < vector1.Dimension; i++)
			{
				d = d + Math.Pow(vector1[i] - vector2[i], 2.0);
			}
			return Math.Sqrt(d);
		}

		#endregion

		#region }nb^

		/// <summary>
		/// }nb^iiqjԂB
		/// Ȃ킿Aevf̍̐Βl̑aB
		/// </summary>

		public static double GetManhattanDistance(IVector vector1, IVector vector2)
		{
			CheckDimension(vector1, vector2);
			double d = 0.0;
			for (int i = 0; i < vector1.Dimension; i++)
			{
				d = d + Math.Abs(vector1[i] - vector2[i]);
			}
			return d;
		}

		#endregion

		#region 

		/// <summary>
		/// 2̃xNgԂ̓ςvZB
		/// </summary>
		/// <param name="vector1"></param>
		/// <param name="vector2"></param>
		/// <returns></returns>
		public static double GetInnerProduct(IVector vector1, IVector vector2)
		{
			CheckDimension(vector1, vector2);
			double ip = 0.0;
			for (int i = 0; i < vector1.Dimension; i++)
			{
				ip += vector1[i] * vector2[i];
			}
			return ip;
		}

		#endregion

		#region RTC

		/// <summary>
		/// 2̃xNgԂ̃RTClvZB
		/// </summary>
		/// <param name="vector1"></param>
		/// <param name="vector2"></param>
		/// <returns></returns>
		public static double GetCosine(IVector vector1, IVector vector2)
		{
			CheckDimension(vector1, vector2);
			double ip = GetInnerProduct(vector1, vector2);
			double cos = ip / (GetEuclideanDistance(vector1) * GetEuclideanDistance(vector2));
			return cos;
		}

		#endregion

		#region JaccardW

		/// <summary>
		/// JaccardWԂB̓Iɂ́A̎ɂvZB
		/// Jaccard = (vector1,vector2) / (|vector1|^2 + |vector2|^2 - (vector1,vector2)) 
		/// </summary>

		public static double GetJaccardCoefficient(IVector vector1, IVector vector2)
		{
			double v1 = 0, v2 = 0;
			double inner = GetInnerProduct(vector1, vector2);

			CheckDimension(vector1, vector2);

			for (int i = 0; i < vector1.Dimension; i++)
			{
				v1 += vector1[i] * vector1[i];
				v2 += vector2[i] * vector2[i];
			}

			return inner / (v1 + v2 - inner);
		}

		#endregion

		#region DiceW

		/// <summary>
		/// DiceWԂB̓Iɂ́A̎ɂvZB
		/// Dice = 2 * (vector1,vector2) / (|vector1|^2) / (|vector2|^2)
		/// </summary>
		public static double GetDiceCoefficient(IVector vector1, IVector vector2)
		{
			double v1 = 0, v2 = 0;

			CheckDimension(vector1, vector2);

			for (int i = 0; i < vector1.Dimension; i++)
			{
				v1 += vector1[i] * vector1[i];
				v2 += vector2[i] * vector2[i];
			}

			return 2 * GetInnerProduct(vector1, vector2) / v1 / v2;
		}

		#endregion

        #region Equals

        /// <summary>
        /// w肵 2  SlothLib.LinearAlgebra.IVector IuWFNg̒lꂩǂ𔻒f܂B
        /// </summary>
        /// <param name="vector1">rΏۂ̑ 1 SlothLib.LinearAlgebra.IVectorB</param>
        /// <param name="vector2">rΏۂ̑ 2 SlothLib.LinearAlgebra.IVectorB</param>
        /// <returns></returns>
        public static bool Equals(IVector vector1, IVector vector2)
        {
            if (ReferenceEquals(vector1, vector2))
            {
                return true;
            }

            if (ReferenceEquals(vector1, null) || ReferenceEquals(vector2, null))
            {
                return false;
            }

            return vector1.Equals(vector2);
        }

        #endregion

        #endregion

        #region vector * vector -> vector ^Z

        #region a

        /// <summary>
		/// xNg̉Z
		/// </summary>
		/// <param name="vector1"></param>
		/// <param name="vector2"></param>
		/// <returns></returns>
		public static IVector Add(IVector vector1, IVector vector2)
		{
			CheckDimension(vector1, vector2);

			IVector r = (IVector)vector1.Clone();

			for (int i = 0; i < vector2.Dimension; i++)
			{
				r[i] += vector2[i];
			}

			return r;
		}

		#endregion

		#region 

		/// <summary>
		/// xNǧZ
		/// </summary>
		/// <param name="vector1"></param>
		/// <param name="vector2"></param>
		/// <returns></returns>
		public static IVector Subtract(IVector vector1, IVector vector2)
		{
			CheckDimension(vector1, vector2);

			return Add(vector1, Negate(vector2));
		}

		#endregion

		#endregion

		#region vector -> vector ^Z

		#region 

		/// <summary>
		/// xNg̕
		/// </summary>
		/// <param name="vector"></param>
		/// <returns></returns>
		public static IVector Negate(IVector vector)
		{
			AbstractVector r = (AbstractVector)vector.Clone();

			for (int i = 0; i < vector.Dimension; i++)
			{
				r[i] = -vector[i];
			}

			return r;
		}

		#endregion

		#endregion

		#region scalar * vector -> vector ^Z

		#region 萔xNg

		/// <summary>
		/// xNg̒萔{
		/// </summary>
		/// <param name="scalar"></param>
		/// <param name="vector"></param>
		/// <returns></returns>
		static public IVector Multiply(double scalar, IVector vector) {
			IVector r = (IVector)vector.Clone();

			for (int i = 0; i < vector.Dimension; i++)
			{
				r[i] = scalar * r[i];
			}

			return r;
		}
		#endregion

		#endregion
	}
}
