using System;
using System.Collections.Generic;
using System.Text;

namespace SlothLib.LinearAlgebra.Vector
{
	/// <summary>
	/// BasicVectorNX̃RNVB
	/// ̃xNgԂ̃̕xNg̏WB
	/// e[uȂǂvZłBi悤ɂ\Bj
	/// </summary>
	/// <remarks>
	/// IVectorC^[tF[X̃RNVł͂ȂƂɒӂB
	/// BasicVectorNX͎ύXłȂNXł邽߁AVectorCollectionNX̎ύX邱Ƃ͂ȂB
	/// <newpara>[2007-01-29][ohshima]쐬</newpara>
	/// <newpara>[2007-04-24][ohshima]C</newpara>
	/// </remarks>
	public class VectorCollection : ICollection<BasicVector>
	{
		/// <summary>
		/// xNgzŕێ
		/// </summary>
		private List<BasicVector> vectorList;

		/// <summary>
		/// xNgԂ̎
		/// </summary>
		private int dimension;


		/// <summary>
		/// RXgN^
		/// </summary>
		/// <param name="vectors"></param>
		public VectorCollection(IEnumerable<BasicVector> vectors)
		{
			this.Initialize(vectors);
		}

		/// <summary>
		/// RXgN^
		/// </summary>
		/// <param name="vectors"></param>
		public VectorCollection(params BasicVector[] vectors)
		{
			this.Initialize(vectors);
		}

		/// <summary>
		/// RXgN^
		/// </summary>
		/// <param name="dimension"></param>
		public VectorCollection(int dimension)
		{
			this.vectorList = new List<BasicVector>();
			this.dimension = dimension;
		}


		/// <summary>
		/// RXgN^̒g
		/// </summary>
		/// <param name="vectors"></param>
		private void Initialize(IEnumerable<BasicVector> vectors)
		{
			this.vectorList = new List<BasicVector>(vectors);
			this.dimension = this.vectorList[0].Dimension;
            //foreach (BasicVector v in this.vectorList)
            //{
            //    this.Add(v);
            //}
		}

		/// <summary>
		/// ێĂX̃xNg
		/// </summary>
		/// <param name="index"></param>
		/// <returns></returns>
		public IVector this[int index]
		{
			get
			{
				if (index >= 0 && index < this.vectorList.Count)
				{
					return this.vectorList[index];
				}
				else
				{
					throw new ArgumentOutOfRangeException("index");
				}
			}
		}

		/// <summary>
		/// xNg̎
		/// </summary>
		public int Dimension
		{
			get
			{
				return this.dimension;
			}
		}

		#region ICollection<IVector> o

		/// <summary>
		/// RNVɐVȃxNgǉB
		/// </summary>
		/// <param name="item"></param>
		public void Add(BasicVector item)
		{
			if (item.Dimension == this.Dimension)
			{
				this.vectorList.Add(item);
			}
			else
			{
				throw new ArgumentException("^xNg̃xNgԂ͑SēłȂĂ͂܂B");
			}
		}

		/// <summary>
		/// RNVɂ
		/// </summary>
		public void Clear()
		{
			this.vectorList.Clear();
		}

		/// <summary>
		/// xNgRNVɊ܂܂Ă邩ǂ
		/// </summary>
		/// <param name="item"></param>
		/// <returns></returns>
		public bool Contains(BasicVector item)
		{
			return this.vectorList.Contains(item);
		}

		/// <summary>
		/// BasicVector̔zɃRNV̓eRs[
		/// </summary>
		/// <param name="array"></param>
		/// <param name="arrayIndex">Rs[Jnʒu</param>
		public void CopyTo(BasicVector[] array, int arrayIndex)
		{
			this.vectorList.CopyTo(array, arrayIndex);
		}

		/// <summary>
		/// RNṼACe
		/// </summary>
		public int Count
		{
			get
			{
				return this.vectorList.Count;
			}
		}

		/// <summary>
		/// falseԂ
		/// </summary>
		public bool IsReadOnly
		{
			get
			{
				return false;
			}
		}

		/// <summary>
		/// RNVACe폜
		/// </summary>
		/// <param name="item"></param>
		/// <returns></returns>
		public bool Remove(BasicVector item)
		{
			return this.vectorList.Remove(item);
		}

		#endregion

		#region IEnumerable<IVector> o

		/// <summary>
		/// 񋓎qԂ
		/// </summary>
		/// <returns></returns>
		public IEnumerator<BasicVector> GetEnumerator()
		{
			return this.vectorList.GetEnumerator();
		}

		#endregion

		#region IEnumerable o

		System.Collections.IEnumerator System.Collections.IEnumerable.GetEnumerator()
		{
			return this.vectorList.GetEnumerator();
		}

		#endregion
	}
}
