using System;
using System.Collections.Generic;
using System.Text;

namespace SlothLib.LinearAlgebra.Matrix
{
	/// <summary>
	/// oCi
    /// Value = (Value != 0) ? 1.0 : 0.0
	/// </summary>
	public class BinaryMatrix : BasicMatrix
	{
		/// <summary>
		/// RXgN^
		/// </summary>
		/// <param name="matrix"></param>
		public BinaryMatrix(IMatrix matrix)
			: base(matrix.RowCount, matrix.ColumnCount)
		{
			for (int i = 0; i < this.RowCount; i++)
			{
				for (int j = 0; j < this.ColumnCount; j++)
				{
                    this[i, j] = (matrix[i, j] != 0.0) ? 1.0 : 0.0;
				}
			}
		}
	}
}
