using System;
using System.Collections.Generic;
using System.Text;

namespace SlothLib.LinearAlgebra.Matrix
{
	/// <summary>
	/// SĂ̍s̊bƂȂNX
	/// </summary>
	/// <remarks>
	/// 
	/// <newpara>[2007-01-30][ohshima]쐬</newpara>
	/// <newpara>[2007-05-01][ohshima]C</newpara>
    /// <newpara>[2007-05-10][kabuotya]C</newpara>
    /// <newpara>[2007-05-15][yamasuke]C</newpara>
    /// <newpara>[2007-07-12][kabutoya]C</newpara>
    /// <newpara>[2007-11-12][kabutoya]C</newpara>
	/// </remarks>
	public class BasicMatrix : AbstractMatrix
	{
		/// <summary>
		/// s̖{̂łz
		/// </summary>
		private double[,] matrix;

        #region RXgN^

        /// <summary>
		/// RXgN^D
		/// </summary>
		/// <param name="row">s</param>
		/// <param name="column"></param>
		public BasicMatrix(int row, int column)
		{
			this.matrix = new double[row, column];
		}

		/// <summary>
		/// RXgN^D
        /// matrixƂɍs쐬D
		/// </summary>
		/// <param name="matrix"></param>
		public BasicMatrix(double[,] matrix)
			: this(matrix.GetLength(0), matrix.GetLength(1))
		{
			for (int r = 0; r < matrix.GetLength(0); r++)
			{
				for (int c = 0; c < matrix.GetLength(1); c++)
				{
					this.matrix[r, c] = matrix[r, c];
				}
			}
		}

		/// <summary>
		/// RXgN^D
        /// matrixƂɍs쐬D
		/// </summary>
		/// <param name="matrix"></param>
		public BasicMatrix(IMatrix matrix)
			: this(matrix.RowCount, matrix.ColumnCount)
		{
			for (int r = 0; r < matrix.RowCount; r++)
			{
				for (int c = 0; c < matrix.ColumnCount; c++)
				{
					this.matrix[r, c] = matrix[r, c];
				}
			}
		}


		/// <summary>
		/// RXgN^B
		/// xNgWA1xNgsƂs쐬B
		/// </summary>
		/// <param name="vectorCollection"></param>
		public BasicMatrix(Vector.VectorCollection vectorCollection)
			: this(vectorCollection.Count, vectorCollection.Dimension)
		{
			for (int r = 0; r < vectorCollection.Count; r++)
			{
				for (int c = 0; c < vectorCollection.Dimension; c++)
				{
					this.matrix[r, c] = vectorCollection[r][c];
				}
			}
        }

        #endregion

        /// <summary>
		/// f[^̔z̃Rs[
		/// </summary>
		public override double[,] GetPlainMatrix()
		{
			return (double[,])this.matrix.Clone();
		}

		/// <summary>
		/// sɃANZX
		/// </summary>
		/// <param name="row">s</param>
		/// <param name="column"></param>
		/// <returns>w肵sƗɂl</returns>
		public override double this[int row, int column]
		{
			get
			{
				//IsIndexInRange(row, column);
                if (this.IsIndexInRange(row, column))
                {
                    return this.matrix[row, column];
                }
                else
                {
                    return default(double);
                }
			}
			set
			{
                if (this.IsIndexInRange(row, column))
                {
                    this.matrix[row, column] = value;
                }
			}
		}

		/// <summary>
		/// s
		/// </summary>
		public override int RowCount
		{
			get
			{
				return this.matrix.GetLength(0);
			}
		}

		/// <summary>
		/// 
		/// </summary>
		public override int ColumnCount
		{
			get
			{
				return this.matrix.GetLength(1);
			}
		}

        /// <summary>
        /// s̕擾
        /// </summary>
        public override object Clone()
        {
            return new BasicMatrix(this.GetPlainMatrix());
        }

        /// <summary>
        /// w肳ꂽCfNXł̍sɃANZXł邩ǂ
        /// </summary>
        /// <param name="row">CfNX̍sԍ</param>
        /// <param name="column">CfNX̗ԍ</param>
        /// <returns>ANZXłꍇtrueCłȂꍇfalse</returns>
        public bool IsIndexInRange(int row, int column)
        {
            bool result = true;

            result = result && (row < this.RowCount);
            result = result && (column < this.ColumnCount);

            return result;
        }

        /// <summary>
        /// ̃xNgƁAw肵 SlothLib.LinearAlgebra.IMatrix IuWFNg̒lꂩǂ𔻒f܂B
        /// </summary>
        /// <param name="value">SlothLib.LinearAlgebra.IMatrixB</param>
        /// <returns></returns>
        public override bool Equals(IMatrix value)
        {
            if (ReferenceEquals(this, value))
            {
                return true;
            }

            if ((this.matrix.GetLength(0) != value.RowCount) || (this.matrix.GetLength(1) != value.ColumnCount))
            {
                return false;
            }

            for (int r = 0; r < this.matrix.GetLength(0); r++)
            {
                for (int c = 0; c < this.matrix.GetLength(1); c++)
                {
                    if (this[r, c] != value[r, c])
                    {
                        return false;
                    }
                }
            }

            return true;
        }
	}
}
