using System;
using System.Collections.Generic;
using System.Text;
using System.Net;
using System.IO;
using System.Runtime.Serialization;
using System.Text.RegularExpressions;


namespace SlothLib.Web.WebLoader
{
	/// <summary>
	/// 擾Weby[W̌ʂۑNXB
	/// </summary>
	[Serializable]
	public class WebGetResult : ISerializable
	{
		private string url;
		private string localFilePath;
		private HttpHeader header;
		private string response;
        //ContentTypegqւ̃nbVe[u
        private Dictionary<string, string> contentTypeToExtentionDirectory;

		/// <summary>
		/// RXgN^
		/// </summary>
		/// <param name="url">擾URL</param>
		/// <param name="localFilePath">ۑt@C̏ꏊ</param>
		/// <param name="header">t@C̃wb_[</param>
		/// <param name="response">T[õX|XiOK݂̂Ȃ琳擾j</param>
		public WebGetResult(string url, string localFilePath, HttpHeader header, string response)
		{
			this.url = url;
			this.localFilePath = localFilePath;
			this.header = header;
			this.response = response;
            this.contentTypeToExtentionDirectory = new Dictionary<string, string>();
            this.InitializeHashTable();


			System.Diagnostics.Debug.WriteLine("Path: " + this.localFilePath);
		}
		/// <summary>
		/// 擾URL
		/// </summary>
		public string URL
		{
			get { return this.url; }
		}
		/// <summary>
		/// ۑt@C̏ꏊ
		/// </summary>
		public string LocalFilePath
		{
			get
			{
				return this.localFilePath;
			}
			set
			{
				this.MoveFile(value);
			}
		}
		/// <summary>
		/// t@C̃wb_[
		/// </summary>
		public HttpHeader Header
		{
			get { return this.header; }
		}
		/// <summary>
		/// X|X
		/// </summary>
		public string Response
		{
			get { return this.response; }
        }

        #region gqύX
        /// <summary>
        /// t@C̊gqύX
        /// </summary>
        public void ChangeExtension()
        {

            string extension = GetExtensionByContentType(this.Header.ContentType);
            this.MoveFile(this.localFilePath + "." + extension);
            System.Diagnostics.Debug.WriteLine(this.localFilePath + "." + extension);


        }

        private string GetExtensionByContentType(string ContentType)
        {
            if (!string.IsNullOrEmpty(ContentType) && this.contentTypeToExtentionDirectory.ContainsKey(ContentType))
            {
                return this.contentTypeToExtentionDirectory[ContentType];
            }
            else
            {
                return "tmp";
            }
        }

        /// <summary>
        /// Reg^CvƊgqΉ
        /// ނ͓K
        /// </summary>
        private void InitializeHashTable()
        {
            this.contentTypeToExtentionDirectory = new Dictionary<string, string>();
            this.contentTypeToExtentionDirectory.Add("text/html", "html");
            this.contentTypeToExtentionDirectory.Add("text/plain", "txt");
            this.contentTypeToExtentionDirectory.Add("text/xml", "xml");
            this.contentTypeToExtentionDirectory.Add("application/pdf", "pdf");
            this.contentTypeToExtentionDirectory.Add("application/msword", "doc");
            this.contentTypeToExtentionDirectory.Add("application/zip", "zip");
            this.contentTypeToExtentionDirectory.Add("application/x-zip-compressed", "zip");
            this.contentTypeToExtentionDirectory.Add("image/x-png", "png");
            this.contentTypeToExtentionDirectory.Add("image/png", "png");
            this.contentTypeToExtentionDirectory.Add("application/x-shockwave-flash", "swf");
            this.contentTypeToExtentionDirectory.Add("application/mspowerpoint", "ppt");
            this.contentTypeToExtentionDirectory.Add("application/ppt", "ppt");
        }
        #endregion

        #region FileړiOύXR~j

        /// <summary>
		/// t@Cړ
		/// </summary>
		/// <param name="destFileName"></param>
		public void MoveFile(string destFileName)
		{
			// fBNgȂꍇ͍쐬B
			FileInfo fi = new FileInfo(destFileName);
			DirectoryInfo di = fi.Directory;
			if (!di.Exists)
			{
				di.Create();
			}

			// łɃt@C݂ĂƂ́A㏑B
			if (fi.Exists)
			{
				fi.Delete();
			}

			// t@C̈ړ
			File.Move(this.localFilePath, destFileName);
			// localFilePath̏
			this.localFilePath = destFileName;
		}


		#endregion


		#region File폜

		/// <summary>
		/// f[^i[Ăt@C폜
		/// </summary>
		public void DeleteFile()
		{
			if (File.Exists(this.localFilePath))
			{
				File.Delete(this.localFilePath);
			}
		}

		#endregion

		#region ISerializable o

		/// <summary>
		/// VACYƂɌĂяo֐
		/// </summary>
		/// <param name="info">tVAɕKvȂׂẴf[^</param>
		/// <param name="context">VAXg[̓]Ɠ]</param>
		void ISerializable.GetObjectData(SerializationInfo info, StreamingContext context)
		{
			info.AddValue("url", this.url);
			info.AddValue("header", this.header);
			info.AddValue("localFilePath", this.localFilePath);
			info.AddValue("response", this.response);
		}


		/// <summary>
		/// VACYꂽ̂fVACYꂽƂɌĂ΂RXgN^
		/// </summary>
		/// <param name="info">VAɕKvȂׂẴf[^</param>
		/// <param name="context">VAXg[̓]Ɠ]</param>
		protected WebGetResult(SerializationInfo info, StreamingContext context)
		{
			this.url = info.GetString("url");
			this.header = (HttpHeader)info.GetValue("header", typeof(HttpHeader));
			this.localFilePath = info.GetString("localFilePath");
			this.response = info.GetString("response");
		}

		#endregion
	}
}
