using System;
using System.Collections.Generic;
using System.Text;
using System.Threading;
using System.IO;
using System.Net;

namespace SlothLib.Web.WebLoader
{
    /// <summary>
    /// }`XbhpĕURL̓e擾NX
    /// </summary>
    public class MultiWebGet
    {
        #region privatetB[h

        private int threadCount;
        private string proxy;
        private string userAgent;
        private int count;

        //IXbh̐
        private int finishedThread;
        private int urlCount;
        private WebGetResult[] result;

        //XbhImpCxg
        private ManualResetEvent finishEvent;

        //XbhpfQ[g
        private delegate void WorkerDelegate(WebGetManager wgm);
        private static WorkerDelegate workerDelegate;

        #endregion

        #region RXgN^

        /// <summary>
        /// RXgN^
        /// </summary>
        public MultiWebGet()
        {
            this.proxy = null;
            this.userAgent = null;
            this.threadCount = DEFAULT_THREAD_COUNT;
            this.count = 0;
           
        }

        #endregion

        #region DoFetch

        /// <summary>
        /// }`Xbh𗘗pĕURL̃f[^擾
        /// </summary>
        /// <param name="urlList">f[^擾URL̃Xg</param>
        /// <returns>MultiWebGetResults^̌</returns>
        public MultiWebGetResults DoFetch(string[] urlList)
        {
            return this.DoFetch(urlList, null, null);
        }

        /// <summary>
        /// }`Xbh𗘗pĕURL̃f[^擾
        /// </summary>
        /// <param name="urlList">f[^擾URL̃Xg</param>
        /// <param name="outputFileList">擾URL̃XgɑΉo̓t@C̃Xg</param>
        /// <returns>MultiWebGetResults^̌</returns>
        public MultiWebGetResults DoFetch(string[] urlList, string[] outputFileList)
        {
            return this.DoFetch(urlList, outputFileList, null, null);
        }



        /// <summary>
        /// }`Xbh𗘗pĕURL̃f[^擾
        /// </summary>
        /// <param name="urlList">f[^擾URL̃Xg</param>
        /// <param name="allowContentTypes">擾URLCotentTypẽXg</param>
        /// <param name="excludeContentTypes">擾ȂURLCotentTypẽXg</param>
        /// <returns>MultiWebGetResults^̌</returns>
        public MultiWebGetResults DoFetch(string[] urlList, string[] allowContentTypes, string[] excludeContentTypes)
        {
            string[] tmpFileNameList = new string[urlList.Length];

            for (int i = 0; i < urlList.Length; i++)
            {
                tmpFileNameList[i] = GetTempFileName(urlList[i]);
            }

            return this.DoFetch(urlList, tmpFileNameList, allowContentTypes, excludeContentTypes);
            
        }

        /// <summary>
        /// }`Xbh𗘗pĕURL̃f[^擾
        /// </summary>
        /// <param name="urlList">f[^擾URL̃Xg</param>
        /// <param name="outputFileList">擾URL̃XgɑΉo̓t@C̃Xg</param>
        /// <param name="allowContentTypes">擾URLCotentTypẽXg</param>
        /// <param name="excludeContentTypes">擾ȂURLCotentTypẽXg</param>
        /// <returns></returns>
        public MultiWebGetResults DoFetch(string[] urlList, string[] outputFileList, string[] allowContentTypes, string[] excludeContentTypes)
        {
            if (urlList.Length > outputFileList.Length)
            {
                System.Diagnostics.Debug.WriteLine("MultiWebGet:擾URLXgƑΉo̓t@CXg̗vfΉĂ܂");
                return null;
            }

            // I܂ƂCxg
            finishEvent = new ManualResetEvent(false);

            finishedThread = 0;
            urlCount = urlList.Length;
            result = new WebGetResult[urlList.Length];

            //Xbhv[̍őgpXbhݒ肷iʂ̂Hj
            ThreadPool.SetMaxThreads(this.ThreadCount, this.ThreadCount);
            workerDelegate = new WorkerDelegate(WorkerThread);

            for (int i = 0; i < urlList.Length; i++)
            {
                //fQ[gʂă}`XbhŃf[^擾
                workerDelegate.BeginInvoke(new WebGetManager(i, urlList[i], outputFileList[i], allowContentTypes, excludeContentTypes, this.Proxy, this.UserAgent),
                     new AsyncCallback(CallbackMethod), i);
            }

            //XbhSďI܂őҋ@
            finishEvent.WaitOne();


            return new MultiWebGetResults(result);
        }

        /// <summary>
        /// ۂɓXbh
        /// </summary>
        /// <param name="wgm"></param>
        /// <returns></returns>
        private void WorkerThread(object wgm)
        {
            WebGetManager wgManager = (WebGetManager)wgm;
            System.Diagnostics.Debug.WriteLine("Start Thread" + wgManager.Index);
            WebGetResult res = wgManager.call();
            result[wgManager.Index] = wgManager.call();
            return;
        }

        /// <summary>
        ///@eXbhIۂɓ삷R[obN
        /// </summary>
        /// <param name="ar"></param>
        private void CallbackMethod(IAsyncResult ar)
        {
            workerDelegate.EndInvoke(ar);
            System.Diagnostics.Debug.WriteLine("End Of Thread" + ar.AsyncState);
            //IXbhP₷
            Interlocked.Increment(ref finishedThread);
            if (urlCount == finishedThread)
            {
                //S̃XbhÎŃCxgVOiԂɂ
                System.Diagnostics.Debug.WriteLine("Finish All Threads!" + ar.AsyncState);
                finishEvent.Set();
            }

            return;
            
        }

        #endregion

        #region private֐

        /// <summary>
        /// URLꎞt@C𓾂
        /// </summary>
        /// <param name="url"></param>
        /// <returns></returns>
        private string GetTempFileName(string url)
        {
            return Path.GetTempPath() + GetHashName(url);
        }

        /// <summary>
        /// URLӂ̃t@C𓾂
        /// </summary>
        /// <param name="url"></param>
        /// <returns></returns>
        private string GetHashName(string url)
        {
            return url.GetHashCode().ToString() + DateTime.Now.GetHashCode() + ((int)count++).ToString()  + ".tmp";
        }

        #endregion

        #region vpeB

        /// <summary>
        /// HTTPʐMɗpproxyT[o
        /// </summary>
        public string Proxy
        {
            set
            {
                this.proxy = value;
            }
            get
            {
                return this.proxy;
            }
        }

        /// <summary>
        /// HTTPʐMɗpUserAgent
        /// </summary>
        public string UserAgent
        {
            set
            {
                this.userAgent = value;
            }
            get
            {
                return this.userAgent;
            }
        }

        /// <summary>
        /// Web̎擾ɗpXbh̐
        /// </summary>
        public int ThreadCount
        {
            get
            {
                return this.threadCount;
            }
            set
            {
                if (value > MAX_THREAD_COUNT)
                {
                    this.threadCount = MAX_THREAD_COUNT;
                }
                else if (value < 0)
                {
                    this.threadCount = 1;
                }
                else
                {
                    this.threadCount = value;
                }
            }
        }

        #endregion

        #region 萔

        private const int MAX_THREAD_COUNT = 20;
        private const int DEFAULT_THREAD_COUNT = 10;

        #endregion
    }
}
