using System;
using System.Collections.Generic;
using System.Text;
using System.Runtime.Serialization;

namespace SlothLib.Web.Search
{

    /// <summary>
    /// Yahoo Web ԂʑŚB
    /// </summary>
    /// <newpara>[2007-09-26][kondo]쐬</newpara>
    [Serializable]
    public class YahooJpLocalSearchResult : ISerializable
    {
        #region privatetB[h

        private YahooJpLocalElement[] resultElements;
		private string query;

        private string latitude;
        private string longitude;
        private double distance;

		private long totalResultsAvailable; // v
		private int totalResultsReturned; // ʐ
		private int firstResultPosition;

		#endregion
		
		#region RXgN^

		/// <summary>
		/// RXgN^
		/// </summary>
        /// <param name="query">NG</param>
        /// <param name="latitude">Ŏw肵ܓx</param>
        /// <param name="longitude">Ŏw肵ox</param>
        /// <param name="distance">Ŏw肵(km)</param>
		/// <param name="totalResultsAvailable">f[^̃}b`NG[łB</param>
		/// <param name="totalResultsReturned">ԋpA}b`NG[̐łBLȌʂ̍vȂꍇAvʂ̐菭Ȃꍇ܂B</param>
		/// <param name="firstResultPosition">Sʂ̍ŏ̃|WVłB</param>
        /// <param name="resultElements">ʗvf</param>
		public YahooJpLocalSearchResult(string query, string latitude, string longitude, double distance, long totalResultsAvailable, int totalResultsReturned, int firstResultPosition, YahooJpLocalElement[] resultElements)
		{
			this.query = query;
            this.latitude = latitude;
            this.longitude = longitude;
            this.distance = distance;
            this.totalResultsAvailable = totalResultsAvailable;
			this.totalResultsReturned = totalResultsReturned;
			this.firstResultPosition = firstResultPosition;
            this.resultElements = resultElements;
        }

        #endregion 
		
		#region vpeB

        /// <summary>
        /// ʗvf̔z
        /// </summary>
        public YahooJpLocalElement[] ResultElements
        {
            get { return this.resultElements; }
        }

		/// <summary>
		/// ɎgꂽNG
		/// </summary>
		public string Query
		{
            get { return this.query;  }
		}

        /// <summary>
        /// Ŏw肵ܓx
        /// </summary>
        public string Latitude
        {
            get { return this.latitude; }
        }

        /// <summary>
        /// Ŏw肵ox
        /// </summary>
        public string Longitude
        {
            get { return this.longitude; }
        }

        /// <summary>
        /// Ŏw肵
        /// </summary>
        public double Distance
        {
            get { return this.distance; }
        }

		/// <summary>
		/// 
		/// </summary>
		public long TotalResultsAvailable
		{
			get { return this.totalResultsAvailable; }
		}

		/// <summary>
		/// ̌ʂɊ܂܂錟ʐ
		/// </summary>
		public int TotalResultsReturned
		{
			get { return this.totalResultsReturned; }
		}

		/// <summary>
		/// Sʂ̍ŏ̃|WV
		/// </summary>
		public int FirstResultPosition
		{
			get { return this.firstResultPosition; }
		}

		#endregion

		#region ISerializable o

        /// <summary>
        /// VACYƂɌĂяo֐
        /// </summary>
        /// <param name="info">tVAɕKvȂׂẴf[^</param>
        /// <param name="context">VAXg[̓]Ɠ]</param>
		void System.Runtime.Serialization.ISerializable.GetObjectData(SerializationInfo info, StreamingContext context)
		{
            info.AddValue("query", this.query);
            info.AddValue("latitude", this.latitude);
            info.AddValue("longitude", this.longitude);
            info.AddValue("distance", this.distance);
			info.AddValue("totalResultsAvailable", this.totalResultsAvailable);
			info.AddValue("totalResultsReturned", this.totalResultsReturned);
			info.AddValue("firstResultPosition", this.firstResultPosition);
            info.AddValue("resultElements", this.resultElements);
        }

		/// <summary>
		/// VACYꂽ̂fVACYꂽƂɌĂ΂RXgN^
		/// </summary>
        /// <param name="info">VAɕKvȂׂẴf[^</param>
        /// <param name="context">VAXg[̓]Ɠ]</param>
		protected YahooJpLocalSearchResult(SerializationInfo info, StreamingContext context)
		{
            this.query = info.GetString("query");
            this.latitude = info.GetString("latitude");
            this.longitude = info.GetString("longitude");
            this.distance = info.GetDouble("distance");
			this.totalResultsAvailable = info.GetInt64("totalResultsAvailable");
			this.totalResultsReturned = info.GetInt32("totalResultsReturned");
			this.firstResultPosition = info.GetInt32("firstResultPosition");
            //this.elementList = (List<ISearchResultElement>)info.GetValue("elementList", typeof(List<ISearchResultElement>));
            this.resultElements = (YahooJpLocalElement[])info.GetValue("resultElements", typeof(YahooJpLocalElement[]));
        }

		#endregion
    }
}
