using System;
using System.Collections.Generic;
using System.Text;
using System.Xml;
using System.Net;
using System.IO;

namespace SlothLib.Web.Search
{
    /// <summary>
	/// Yahoo!EFuWebT[rX
	/// http://developer.yahoo.co.jp/search/web/V1/localsearch.html
	/// </summary>
	/// <remarks>
	/// 
	/// <newpara>[2007-09-26][kondo]쐬</newpara>
	/// </remarks>
    public class YahooJpLocalSearch
    {
        #region vCx[gtB[h

		// AvP[VID
		private string applicationID;

		// query  results(resultNumber) ȊÖ
        private CategoryType category;
        private int start;
        private DatumType datum;
        private AreaLevelType areaLevel;

        // proxy
        private WebProxy proxy;

		#endregion

		
		#region RXgN^

		/// <summary>
		/// RXgN^
		/// AvP[VIDw肷
		/// </summary>
		/// <param name="applicationID">vOŗpAvP[VID</param>

		public YahooJpLocalSearch(string applicationID)
		{
			this.applicationID = applicationID;

			// query  resultNumber, latitude, longitude, distance ȊÖ
            this.category = CategoryType.def;
            this.start = 1;
            this.datum = DatumType.tky;
            this.areaLevel = AreaLevelType.none;
		}

		#endregion


		#region public \bh

		/// <summary>
		/// Yahoo![JsBNG͂邱ƂŌoܓx
		/// </summary>
		/// <param name="query">NG[łB</param>
		/// <param name="maxNumber">ԋpʂ̐łB</param>
		/// <returns>YahooJapanLocalSearchResult^̌</returns>
		public YahooJpLocalSearchResult DoSearch(string query, int maxNumber)
		{
            return DoSearchOriginal(query, String.Empty, String.Empty, 0, maxNumber, start);
		}

        /// <summary>
        /// Yahoo![JsBn_Ƃ̒n_̋w肷邱ƂŎӎ{݂̌oܓx擾ł
        /// </summary>
        /// <param name="latitude">w肵ꏊ̈ܓx</param>
        /// <param name="longitude">w肵ꏊ̌ox</param>
        /// <param name="distance">w肵ꏊ̋</param>
        /// <param name="maxNumber">ԋpʂ̐łB</param>
        /// <returns>YahooJapanLocalSearchResult^̌</returns>
        public YahooJpLocalSearchResult DoSearch(string latitude, string longitude, double distance, int maxNumber)
        {
            return DoSearchOriginal(String.Empty, latitude, longitude, distance, maxNumber, start);
        }

		#endregion


		#region vpeB

        /// <summary>
        /// ΏۃJeS
        /// </summary>
        public CategoryType Category
        {
            get { return this.category; }
            set { this.category = value; }
        }

        /// <summary>
        /// w肵ܓxox̑nn
        /// tky - {nn 
        /// wgs - Enn 
        /// </summary>
        public DatumType Datum
        {
            get { return this.datum; }
            set { this.datum = value; }
        }

        /// <summary>
        /// Zx̍i荞
        /// 1 - s撬x 
        /// 2 - A厚x 
        /// 3 - ځAx 
        /// </summary>
        public AreaLevelType AreaLevel
        {
            get { return this.areaLevel; }
            set { this.areaLevel = value; }
        }
           

		#endregion


		#region Proxyݒ

		/// <summary>
		/// vNV擾Eݒ肷B
		/// </summary>
        public string Proxy
        {
            set
            {
                if ( string.IsNullOrEmpty(value))
                {
                    this.proxy = null;
                }
                else
                {
                    this.proxy = new WebProxy(value);
                }
            }
            get
            {
                return this.proxy.Address.AbsoluteUri;
            }
        }

		#endregion


		#region t@\̌\bh

        /// <summary>
		/// 50܂łYahoo![Js
		/// </summary>
		/// <param name="query">NG[łB</param>
        /// <param name="latitude">Ŏw肷ox</param>
        /// <param name="longitude">Ŏw肷ܓx</param>
        /// <param name="distance">Ŏw肷鋗</param>
		/// <param name="results">ԋpʂ̐łB</param>
		/// <param name="start">ԋpʂ̐擪ʒułBŏIʒuistart + results - 1j́A100𒴂܂B</param>
		/// <returns>YahooWebSearchResult^̌</returns>
		private YahooJpLocalSearchResult DoSearchOriginal(string query, string latitude, string longitude, double distance, int results, int start)
		{
            string requestURL = MakeRequestURL(query, latitude, longitude, distance, category, start, results, datum, areaLevel);
			//System.Diagnostics.Debug.WriteLine(requestURL);
			XmlDocument xmlDoc = new XmlDocument();

			HttpStatusCode statusCode;

			HttpWebRequest req = (HttpWebRequest)WebRequest.Create(requestURL);
			if (this.proxy != null)
			{
				req.Proxy = proxy;
			}
			using (HttpWebResponse res = (HttpWebResponse)req.GetResponse())
			using (Stream st = res.GetResponseStream())
			{
				xmlDoc.Load(st);
				statusCode = res.StatusCode;
			}

			// [g̗vf擾
			XmlElement xmlRoot = xmlDoc.DocumentElement;

			//ErrorAĂꍇ
			//if (xmlRoot.Name.Equals("Error"))
			if (statusCode != HttpStatusCode.OK)
			{
				// ObZ[W擾
				string errorMessage = GetElementString(xmlRoot.GetElementsByTagName("Message"));
				// O𓊂B
				ThrowException(statusCode, errorMessage);
			}

			// <LocalSearchResult>vfCount,ViewCount̑l擾
            ;
            long totalResultsAvailable = long.Parse(GetElementString(xmlRoot.GetElementsByTagName("Count")));
            int totalResultsReturned = int.Parse(GetElementString(xmlRoot.GetElementsByTagName("ViewCount")));
            int firstResultPosition = start;

			// ʗvfĂ
			List<YahooJpLocalElement> ResultElementList = new List<YahooJpLocalElement>();

			XmlNodeList xmlResultList = xmlRoot.GetElementsByTagName("Item");
       
			foreach (XmlElement xmlResult in xmlResultList)
			{
                string cat = GetElementString(xmlResult.GetElementsByTagName("Category"));
                string title = GetElementString(xmlResult.GetElementsByTagName("Title"));
                string address = GetElementString(xmlResult.GetElementsByTagName("Address"));
                string addressLevel = GetElementString(xmlResult.GetElementsByTagName("AddressLevel"));

                XmlElement xmlDatumTky = (XmlElement) xmlResult.GetElementsByTagName("DatumTky97")[0];
                string datumTky97_lat = GetElementString(xmlDatumTky.GetElementsByTagName("Lat"));
                string datumTky97_lon = GetElementString(xmlDatumTky.GetElementsByTagName("Lon"));

                XmlElement xmlDatumWgs = (XmlElement) xmlResult.GetElementsByTagName("DatumWgs84")[0];
                string datumWgs84_lat = GetElementString(xmlDatumWgs.GetElementsByTagName("Lat"));
                string datumWgs84_lon = GetElementString(xmlDatumWgs.GetElementsByTagName("Lon"));
                
                string url = GetElementString(xmlResult.GetElementsByTagName("Url"));
                

                YahooJpLocalElement result = new YahooJpLocalElement(cat, title, address, addressLevel, datumTky97_lat, datumTky97_lon, datumWgs84_lat, datumWgs84_lon, url);

				ResultElementList.Add(result);
			}

            return new YahooJpLocalSearchResult(query, latitude, longitude, distance, totalResultsAvailable, totalResultsReturned, firstResultPosition, ResultElementList.ToArray());

		}

		#endregion


		#region Gp\bh

        /// <summary>
        /// XmlNodeList̏߂̃m[h̃eLXg擾
        /// </summary>
        /// <param name="nodeList">XmlNodeList</param>
        /// <returns>XmlNodeList̏߂̃m[hInnerText
        ///          XmlNodeListł΋󕶎Ԃ</returns>
        private string GetElementString(XmlNodeList nodeList)
        {
            if (nodeList.Count == 0)
            {
                return string.Empty;
            }
            else
            {
                return nodeList[0].InnerText;
            }
        }


		/// <summary>
		/// O𓊂
		/// </summary>
		/// <param name="errorCode"></param>
		/// <param name="errorMessage"></param>
		private void ThrowException(HttpStatusCode errorCode, string errorMessage)
		{
			switch (errorCode)
			{
				case HttpStatusCode.BadRequest: // 400
					throw new YahooJpSearchException(YahooJpSearchException.HttpCode.BadRequest, errorMessage);
				case HttpStatusCode.Forbidden: // 403
					throw new YahooJpSearchException(YahooJpSearchException.HttpCode.Forbidden, errorMessage);
				case HttpStatusCode.ServiceUnavailable: // 503
					throw new YahooJpSearchException(YahooJpSearchException.HttpCode.ServiceUnavailable, errorMessage);
				default:
                    throw new Exception("YahooWebSearchőzOHTTPG[܂BiG[R[h: " + (int)errorCode + "j" + errorMessage);
            }
		}

        ///// <summary>
        ///// XmlNodeList̏߂̃m[h̃eLXg擾
        ///// </summary>
        ///// <param name="nodeList">XmlNodeList</param>
        ///// <returns>XmlNodeList̏߂̃m[hInnerText
        /////          XmlNodeListł΋󕶎Ԃ</returns>
        //private string GetElementString(XmlNodeList nodeList)
        //{
        //    if (nodeList.Count == 0)
        //    {
        //        return string.Empty;
        //    }
        //    else
        //    {
        //        return nodeList[0].InnerText;
        //    }
        //}

		/// <summary>
		/// NGXgURL쐬
		/// </summary>
		/// <param name="query">NG[</param>
        /// <param name="latitude">Ŏw肷ܓx</param>
        /// <param name="longitude">Ŏw肷ox</param>
        /// <param name="distance">Ŏw肷鋗(w肵Ȃꍇnull)</param>
        /// <param name="category">ΏۃJeS</param>
        /// <param name="start">\Jnʒu</param>
        /// <param name="results">\</param>
        /// <param name="datum">w肵oxܓx̑nn</param>
        /// <param name="areaLevel">Zx̍i荞</param>
		/// <returns>URL</returns>
		private string MakeRequestURL(string query, string latitude, string longitude, double distance, CategoryType category , 
            int start, int results, DatumType datum , AreaLevelType arealevel)
		{
            string strQuery = string.Empty;
            string strLatitude = string.Empty;
            string strLongitude = string.Empty;
            string strDistance = string.Empty;
            string strCategory = string.Empty;
			string strDatum = string.Empty;
			string strArealevel = string.Empty;

            switch (category)
            {
                case CategoryType.def:
                    break;
                case CategoryType.address:
                    strCategory = "&category=address";
                    break;
                case CategoryType.zipcode:
                    strCategory = "&category=zipcode";
                    break;
                case CategoryType.landmark:
                    strCategory = "&category=landmark";
                    break;
                case CategoryType.station:
                    strCategory = "&category=station";
                    break;
                case CategoryType.courpon:
                    strCategory = "&category=courpon";
                    break;
                    
            }

            switch (datum)
            {
                case DatumType.tky:
                    strDatum = "&datum=tky";
                    break;
                case DatumType.wgs:
                    strDatum = "&datum=wgs";
                    break;
            }

			switch (arealevel)
			{
				case AreaLevelType.none:
					break;
				case AreaLevelType.city:
                    strArealevel = "&al=1";
					break;
				case AreaLevelType.streetAddress:
                    strArealevel = "&al=2";
					break;
                case AreaLevelType.streetNumber:
                    strArealevel = "&al=3";
                    break;
			}

            if (!String.IsNullOrEmpty(query))
            {
                strQuery = "&p=" + query;
            }

			if (!String.IsNullOrEmpty(latitude))
			{
				strLatitude = "&lat=" + latitude;
			}

            if (!String.IsNullOrEmpty(longitude))
            {
                strLongitude = "&lon=" + longitude;
            }
            if (!(distance == 0))
            {
                strDistance = "&dist=" + distance.ToString();
            }

            string uriString = "http://api.map.yahoo.co.jp/LocalSearchService/V1/LocalSearch?"
            + "appid=" + this.applicationID
            + strQuery
            + strLatitude
            + strLongitude
            + strDistance
            + strCategory
            + "&b=" + start.ToString()
            + "&n=" + results.ToString()
            + strDatum
            + strArealevel;

			//return uriString;

			Uri uri = new Uri(uriString);
			string result = uri.AbsoluteUri;
			//System.Diagnostics.Debug.WriteLine(result);
            
			return result;
		}

		#endregion


		#region Ŏw肷邽߂̗񋓌^

        /// <summary>
        /// ΏۃJeS
        /// </summary>
        public enum CategoryType
        {
            /// <summary>
            /// ZΏۂɌ
            /// </summary>
            address,
            /// <summary>
            /// X֔ԍΏۂɌ
            /// </summary>
            zipcode,
            /// <summary>
            /// {݁iAwZAa@AX֋ǂȂǁjΏۂɌ 
            /// </summary>
            landmark,
            /// <summary>
            /// wΏۂɌ 
            /// </summary>
            station,
            /// <summary>
            /// Yahoo!N[|ΏۂɌ 
            /// </summary>
            courpon,

            /// <summary>
            /// ftHgBaddress, zipcode, landmark, stationΏ
            /// </summary>
            def
        }

        /// <summary>
        /// w肵oxܓx̑nn
        /// </summary>
        public enum DatumType
        {
            /// <summary>
            /// {nn
            /// </summary>
            tky,
            /// <summary>
            /// Enn
            /// </summary>
            wgs
        }

        /// <summary>
        /// Zx̍i荞
        /// </summary>
        public enum AreaLevelType
        {
            /// <summary>
            /// sx
            /// </summary>
            city,
            /// <summary>
            /// A厚x
            /// </summary>
            streetAddress,
            /// <summary>
            /// ځAx
            /// </summary>
            streetNumber,
            /// <summary>
            /// i荞܂Ȃ
            /// </summary>
            none
        }

		#endregion
    }
}
