/*
 * Decompiled with CFR 0.152.
 */
package org.apache.woden.internal.xml;

import org.apache.woden.ErrorLocator;
import org.apache.woden.WSDLException;
import org.apache.woden.XMLElement;
import org.apache.woden.internal.ErrorLocatorImpl;
import org.apache.woden.internal.xml.XMLAttrImpl;
import org.apache.woden.xml.IntOrTokenAttr;

public class IntOrTokenAnyAttrImpl
extends XMLAttrImpl
implements IntOrTokenAttr {
    public boolean isInt() {
        return this.fContent instanceof Integer;
    }

    public boolean isToken() {
        return !this.isInt() && this.isValid();
    }

    public Integer getInt() {
        if (this.isInt()) {
            return (Integer)this.fContent;
        }
        return null;
    }

    public String getToken() {
        if (!this.isInt() && this.isValid()) {
            return (String)this.fContent;
        }
        return null;
    }

    protected Object convert(XMLElement ownerEl, String attrValue) throws WSDLException {
        if ("#any".equals(attrValue)) {
            return attrValue;
        }
        Integer intVal = null;
        try {
            intVal = new Integer(attrValue);
        }
        catch (NumberFormatException e) {
            this.setValid(false);
            this.getErrorReporter().reportError((ErrorLocator)new ErrorLocatorImpl(), "WSDL512", new Object[]{attrValue}, (short)2, (Exception)e);
        }
        return intVal;
    }
}

