/*
 * Decompiled with CFR 0.152.
 */
package org.apache.woden.internal.wsdl20;

import java.net.URI;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Vector;
import javax.xml.namespace.QName;
import org.apache.woden.internal.wsdl20.DescriptionImpl;
import org.apache.woden.internal.wsdl20.DocumentableImpl;
import org.apache.woden.internal.wsdl20.InterfaceFaultImpl;
import org.apache.woden.internal.wsdl20.InterfaceOperationImpl;
import org.apache.woden.types.NCName;
import org.apache.woden.wsdl20.Description;
import org.apache.woden.wsdl20.Interface;
import org.apache.woden.wsdl20.InterfaceFault;
import org.apache.woden.wsdl20.InterfaceOperation;
import org.apache.woden.wsdl20.WSDLComponent;
import org.apache.woden.wsdl20.xml.InterfaceElement;
import org.apache.woden.wsdl20.xml.InterfaceFaultElement;
import org.apache.woden.wsdl20.xml.InterfaceOperationElement;
import org.apache.woden.wsdl20.xml.WSDLElement;

public class InterfaceImpl
extends DocumentableImpl
implements Interface,
InterfaceElement {
    private WSDLElement fParentElem = null;
    private Description fDescriptionComponent = null;
    private NCName fName = null;
    private List fExtends = new Vector();
    private List fStyleDefault = new Vector();
    private List fInterfaceFaultElements = new Vector();
    private List fInterfaceOperationElements = new Vector();

    public QName getName() {
        QName name = null;
        if (this.fName != null) {
            String tns = DescriptionImpl.getTargetNamespace(this);
            name = new QName(tns, this.fName.toString());
        }
        return name;
    }

    public Interface getExtendedInterface(QName qname) {
        Interface intface = this.fDescriptionComponent.getInterface(qname);
        return intface;
    }

    public Interface[] getExtendedInterfaces() {
        Vector<Interface> interfaces = new Vector<Interface>();
        Iterator it = this.fExtends.iterator();
        while (it.hasNext()) {
            QName qn = (QName)it.next();
            Interface intface = this.getExtendedInterface(qn);
            if (intface == null) continue;
            interfaces.add(intface);
        }
        Interface[] array = new Interface[interfaces.size()];
        interfaces.toArray(array);
        return array;
    }

    public InterfaceFault[] getInterfaceFaults() {
        InterfaceFault[] array = new InterfaceFault[this.fInterfaceFaultElements.size()];
        this.fInterfaceFaultElements.toArray(array);
        return array;
    }

    public InterfaceFault getInterfaceFault(QName faultName) {
        return (InterfaceFault)((Object)this.getInterfaceFaultElement(faultName));
    }

    public InterfaceFault[] getAllInterfaceFaults() {
        Vector allInterfaceFaults = new Vector();
        allInterfaceFaults.addAll(this.fInterfaceFaultElements);
        allInterfaceFaults.addAll(this.getDerivedInterfaceFaults());
        InterfaceFault[] array = new InterfaceFault[allInterfaceFaults.size()];
        allInterfaceFaults.toArray(array);
        return array;
    }

    public InterfaceFault getFromAllInterfaceFaults(QName faultName) {
        InterfaceFault theFault = null;
        if (faultName != null) {
            InterfaceFault[] faults = this.getAllInterfaceFaults();
            for (int i = 0; i < faults.length; ++i) {
                InterfaceFault fault = faults[i];
                if (!faultName.equals(fault.getName())) continue;
                theFault = fault;
                break;
            }
        }
        return theFault;
    }

    public InterfaceOperation[] getInterfaceOperations() {
        InterfaceOperation[] array = new InterfaceOperation[this.fInterfaceOperationElements.size()];
        this.fInterfaceOperationElements.toArray(array);
        return array;
    }

    public InterfaceOperation getInterfaceOperation(QName operName) {
        return (InterfaceOperation)((Object)this.getInterfaceOperationElement(operName));
    }

    public InterfaceOperation[] getAllInterfaceOperations() {
        Vector allInterfaceOperations = new Vector();
        allInterfaceOperations.addAll(this.fInterfaceOperationElements);
        allInterfaceOperations.addAll(this.getDerivedInterfaceOperations());
        InterfaceOperation[] array = new InterfaceOperation[allInterfaceOperations.size()];
        allInterfaceOperations.toArray(array);
        return array;
    }

    public InterfaceOperation getFromAllInterfaceOperations(QName operName) {
        InterfaceOperation theOper = null;
        if (operName != null) {
            InterfaceOperation[] opers = this.getAllInterfaceOperations();
            for (int i = 0; i < opers.length; ++i) {
                InterfaceOperation oper = opers[i];
                if (!operName.equals(oper.getName())) continue;
                theOper = oper;
                break;
            }
        }
        return theOper;
    }

    public InterfaceElement toElement() {
        return this;
    }

    public boolean equals(WSDLComponent comp) {
        if (this == comp) {
            return true;
        }
        if (!(comp instanceof Interface)) {
            return false;
        }
        Interface other = (Interface)comp;
        QName myName = this.getName();
        if (myName != null && !myName.equals(other.getName())) {
            return false;
        }
        HashSet thisExtendsSet = new HashSet(this.fExtends);
        QName[] otherExtends = ((InterfaceElement)((Object)other)).getExtendedInterfaceNames();
        HashSet<QName> otherExtendsSet = new HashSet<QName>();
        for (int i = 0; i < otherExtends.length; ++i) {
            otherExtendsSet.add(otherExtends[i]);
        }
        if (thisExtendsSet.size() != otherExtendsSet.size()) {
            return false;
        }
        return thisExtendsSet.containsAll(otherExtendsSet) && otherExtendsSet.containsAll(thisExtendsSet);
    }

    public void setName(NCName name) {
        this.fName = name;
    }

    public void addStyleDefaultURI(URI uri) {
        if (uri != null) {
            this.fStyleDefault.add(uri);
        }
    }

    public URI[] getStyleDefault() {
        URI[] array = new URI[this.fStyleDefault.size()];
        this.fStyleDefault.toArray(array);
        return array;
    }

    public void addExtendedInterfaceName(QName interfaceName) {
        if (interfaceName != null) {
            this.fExtends.add(interfaceName);
        }
    }

    public void removeExtendedInterfaceName(QName interfaceName) {
        if (interfaceName != null) {
            this.fExtends.remove(interfaceName);
        }
    }

    public QName[] getExtendedInterfaceNames() {
        QName[] array = new QName[this.fExtends.size()];
        this.fExtends.toArray(array);
        return array;
    }

    public InterfaceElement getExtendedInterfaceElement(QName interfaceName) {
        Description desc = (Description)((Object)this.fParentElem);
        InterfaceElement intface = (InterfaceElement)((Object)desc.getInterface(interfaceName));
        return intface;
    }

    public InterfaceElement[] getExtendedInterfaceElements() {
        Vector<InterfaceElement> interfaces = new Vector<InterfaceElement>();
        Iterator it = this.fExtends.iterator();
        while (it.hasNext()) {
            QName qn = (QName)it.next();
            InterfaceElement intface = this.getExtendedInterfaceElement(qn);
            if (intface == null) continue;
            interfaces.add(intface);
        }
        InterfaceElement[] array = new InterfaceElement[interfaces.size()];
        interfaces.toArray(array);
        return array;
    }

    public InterfaceFaultElement addInterfaceFaultElement() {
        InterfaceFaultImpl fault = new InterfaceFaultImpl();
        this.fInterfaceFaultElements.add(fault);
        fault.setParentElement(this);
        return fault;
    }

    public InterfaceFaultElement getInterfaceFaultElement(QName faultName) {
        InterfaceFaultElement fault = null;
        if (faultName != null) {
            InterfaceFaultElement tempFault = null;
            Iterator i = this.fInterfaceFaultElements.iterator();
            while (i.hasNext()) {
                tempFault = (InterfaceFaultElement)i.next();
                if (!faultName.equals(tempFault.getName())) continue;
                fault = tempFault;
                break;
            }
        }
        return fault;
    }

    public InterfaceFaultElement[] getInterfaceFaultElements() {
        InterfaceFaultElement[] array = new InterfaceFaultElement[this.fInterfaceFaultElements.size()];
        this.fInterfaceFaultElements.toArray(array);
        return array;
    }

    public InterfaceOperationElement addInterfaceOperationElement() {
        InterfaceOperationImpl operation = new InterfaceOperationImpl();
        this.fInterfaceOperationElements.add(operation);
        operation.setParentElement(this);
        return operation;
    }

    public InterfaceOperationElement getInterfaceOperationElement(QName operName) {
        InterfaceOperationElement oper = null;
        if (operName != null) {
            InterfaceOperationElement tempOper = null;
            Iterator i = this.fInterfaceOperationElements.iterator();
            while (i.hasNext()) {
                tempOper = (InterfaceOperationElement)i.next();
                if (!operName.equals(tempOper.getName())) continue;
                oper = tempOper;
                break;
            }
        }
        return oper;
    }

    public InterfaceOperationElement[] getInterfaceOperationElements() {
        InterfaceOperationElement[] array = new InterfaceOperationElement[this.fInterfaceOperationElements.size()];
        this.fInterfaceOperationElements.toArray(array);
        return array;
    }

    public void setParentElement(WSDLElement parent) {
        this.fParentElem = parent;
    }

    public WSDLElement getParentElement() {
        return this.fParentElem;
    }

    private InterfaceOperation getInScopeInterfaceOperation(QName qname) {
        InterfaceOperation oper = null;
        if (qname != null && (oper = this.getInterfaceOperation(qname)) == null) {
            List derivedOperations = this.getDerivedInterfaceOperations();
            InterfaceOperation tempOper = null;
            Iterator j = derivedOperations.iterator();
            while (j.hasNext()) {
                tempOper = (InterfaceOperation)j.next();
                if (!qname.equals(tempOper.getName())) continue;
                oper = tempOper;
                break;
            }
        }
        return oper;
    }

    private List getDerivedInterfaceOperations() {
        Vector<InterfaceOperation> derivedOperations = new Vector<InterfaceOperation>();
        Interface[] interfaces = this.getExtendedInterfaces();
        for (int i = 0; i < interfaces.length; ++i) {
            Interface interfac = interfaces[i];
            InterfaceOperation[] opers = interfac.getInterfaceOperations();
            for (int j = 0; j < opers.length; ++j) {
                InterfaceOperation oper = opers[j];
                if (this.containsComponent(oper, derivedOperations)) continue;
                derivedOperations.add(oper);
            }
        }
        return derivedOperations;
    }

    private InterfaceFault getInScopeInterfaceFault(QName qname) {
        InterfaceFault fault = null;
        if (qname != null && (fault = this.getInterfaceFault(qname)) == null) {
            List derivedFaults = this.getDerivedInterfaceFaults();
            InterfaceFault tempFault = null;
            Iterator j = derivedFaults.iterator();
            while (j.hasNext()) {
                tempFault = (InterfaceFault)j.next();
                if (!qname.equals(tempFault.getName())) continue;
                fault = tempFault;
                break;
            }
        }
        return fault;
    }

    private List getDerivedInterfaceFaults() {
        Vector<InterfaceFault> derivedFaults = new Vector<InterfaceFault>();
        Interface[] interfaces = this.getExtendedInterfaces();
        for (int i = 0; i < interfaces.length; ++i) {
            Interface interfac = interfaces[i];
            InterfaceFault[] faults = interfac.getInterfaceFaults();
            for (int j = 0; j < faults.length; ++j) {
                InterfaceFault fault = faults[j];
                if (this.containsComponent(fault, derivedFaults)) continue;
                derivedFaults.add(fault);
            }
        }
        return derivedFaults;
    }

    void setDescriptionComponent(Description desc) {
        this.fDescriptionComponent = desc;
    }

    Description getDescriptionComponent() {
        return this.fDescriptionComponent;
    }
}

