/*
 * Decompiled with CFR 0.152.
 */
package org.apache.catalina.tribes.membership;

import java.io.IOException;
import java.net.DatagramPacket;
import java.net.InetAddress;
import java.net.InetSocketAddress;
import java.net.MulticastSocket;
import java.net.SocketTimeoutException;
import java.util.Arrays;
import org.apache.catalina.tribes.Member;
import org.apache.catalina.tribes.MembershipListener;
import org.apache.catalina.tribes.membership.McastService;
import org.apache.catalina.tribes.membership.MemberImpl;
import org.apache.catalina.tribes.membership.Membership;
import org.apache.juli.logging.Log;
import org.apache.juli.logging.LogFactory;

public class McastServiceImpl {
    private static Log log = LogFactory.getLog(McastService.class);
    protected static int MAX_PACKET_SIZE = 65535;
    protected boolean doRunSender = false;
    protected boolean doRunReceiver = false;
    protected int startLevel = 0;
    protected MulticastSocket socket;
    protected MemberImpl member;
    protected InetAddress address;
    protected int port;
    protected long timeToExpiration;
    protected long sendFrequency;
    protected DatagramPacket sendPacket;
    protected DatagramPacket receivePacket;
    protected Membership membership;
    protected MembershipListener service;
    protected ReceiverThread receiver;
    protected SenderThread sender;
    protected long serviceStartTime = System.currentTimeMillis();
    protected int mcastTTL = -1;
    protected int mcastSoTimeout = -1;
    protected InetAddress mcastBindAddress = null;
    protected Object expiredMutex = new Object();

    public McastServiceImpl(MemberImpl member, long sendFrequency, long expireTime, int port, InetAddress bind, InetAddress mcastAddress, int ttl, int soTimeout, MembershipListener service) throws IOException {
        this.member = member;
        this.address = mcastAddress;
        this.port = port;
        this.mcastSoTimeout = soTimeout;
        this.mcastTTL = ttl;
        this.mcastBindAddress = bind;
        this.timeToExpiration = expireTime;
        this.service = service;
        this.sendFrequency = sendFrequency;
        this.setupSocket();
        this.sendPacket = new DatagramPacket(new byte[MAX_PACKET_SIZE], MAX_PACKET_SIZE);
        this.sendPacket.setAddress(this.address);
        this.sendPacket.setPort(port);
        this.receivePacket = new DatagramPacket(new byte[MAX_PACKET_SIZE], MAX_PACKET_SIZE);
        this.receivePacket.setAddress(this.address);
        this.receivePacket.setPort(port);
        this.membership = new Membership(member);
    }

    protected void setupSocket() throws IOException {
        this.socket = this.mcastBindAddress != null ? new MulticastSocket(new InetSocketAddress(this.mcastBindAddress, this.port)) : new MulticastSocket(this.port);
        this.socket.setLoopbackMode(false);
        if (this.mcastBindAddress != null) {
            if (log.isInfoEnabled()) {
                log.info((Object)("Setting multihome multicast interface to:" + this.mcastBindAddress));
            }
            this.socket.setInterface(this.mcastBindAddress);
        }
        if (this.mcastSoTimeout <= 0) {
            this.mcastSoTimeout = (int)this.sendFrequency;
        }
        if (log.isInfoEnabled()) {
            log.info((Object)("Setting cluster mcast soTimeout to " + this.mcastSoTimeout));
        }
        this.socket.setSoTimeout(this.mcastSoTimeout);
        if (this.mcastTTL >= 0) {
            if (log.isInfoEnabled()) {
                log.info((Object)("Setting cluster mcast TTL to " + this.mcastTTL));
            }
            this.socket.setTimeToLive(this.mcastTTL);
        }
    }

    public synchronized void start(int level) throws IOException {
        boolean valid = false;
        if ((level & 4) == 4) {
            if (this.receiver != null) {
                throw new IllegalStateException("McastService.receive already running.");
            }
            if (this.sender == null) {
                this.socket.joinGroup(this.address);
            }
            this.doRunReceiver = true;
            this.receiver = new ReceiverThread();
            this.receiver.setDaemon(true);
            this.receiver.start();
            valid = true;
        }
        if ((level & 8) == 8) {
            if (this.sender != null) {
                throw new IllegalStateException("McastService.send already running.");
            }
            if (this.receiver == null) {
                this.socket.joinGroup(this.address);
            }
            this.send(false);
            this.doRunSender = true;
            this.serviceStartTime = System.currentTimeMillis();
            this.sender = new SenderThread(this.sendFrequency);
            this.sender.setDaemon(true);
            this.sender.start();
            valid = true;
        }
        if (!valid) {
            throw new IllegalArgumentException("Invalid start level. Only acceptable levels are Channel.MBR_RX_SEQ and Channel.MBR_TX_SEQ");
        }
        this.waitForMembers(level);
        this.startLevel |= level;
    }

    private void waitForMembers(int level) {
        long memberwait = this.sendFrequency * 2L;
        if (log.isInfoEnabled()) {
            log.info((Object)("Sleeping for " + memberwait + " milliseconds to establish cluster membership, start level:" + level));
        }
        try {
            Thread.sleep(memberwait);
        }
        catch (InterruptedException ignore) {
            // empty catch block
        }
        if (log.isInfoEnabled()) {
            log.info((Object)("Done sleeping, membership established, start level:" + level));
        }
    }

    public synchronized boolean stop(int level) throws IOException {
        boolean valid = false;
        if ((level & 4) == 4) {
            valid = true;
            this.doRunReceiver = false;
            if (this.receiver != null) {
                this.receiver.interrupt();
            }
            this.receiver = null;
        }
        if ((level & 8) == 8) {
            valid = true;
            this.doRunSender = false;
            if (this.sender != null) {
                this.sender.interrupt();
            }
            this.sender = null;
        }
        if (!valid) {
            throw new IllegalArgumentException("Invalid stop level. Only acceptable levels are Channel.MBR_RX_SEQ and Channel.MBR_TX_SEQ");
        }
        this.startLevel &= ~level;
        if (this.startLevel == 0) {
            this.member.setCommand(Member.SHUTDOWN_PAYLOAD);
            this.member.getData(true, true);
            this.send(false);
            try {
                this.socket.leaveGroup(this.address);
            }
            catch (Exception exception) {
                // empty catch block
            }
            this.serviceStartTime = Long.MAX_VALUE;
        }
        return this.startLevel == 0;
    }

    public void receive() throws IOException {
        try {
            this.socket.receive(this.receivePacket);
            if (this.receivePacket.getLength() > MAX_PACKET_SIZE) {
                log.error((Object)("Multicast packet received was too long, dropping package:" + this.receivePacket.getLength()));
            } else {
                byte[] data = new byte[this.receivePacket.getLength()];
                System.arraycopy(this.receivePacket.getData(), this.receivePacket.getOffset(), data, 0, data.length);
                final MemberImpl m = MemberImpl.getMember(data);
                if (log.isTraceEnabled()) {
                    log.trace((Object)("Mcast receive ping from member " + m));
                }
                Thread t = null;
                if (Arrays.equals(m.getCommand(), Member.SHUTDOWN_PAYLOAD)) {
                    if (log.isDebugEnabled()) {
                        log.debug((Object)("Member has shutdown:" + m));
                    }
                    this.membership.removeMember(m);
                    t = new Thread(){

                        public void run() {
                            McastServiceImpl.this.service.memberDisappeared(m);
                        }
                    };
                } else if (this.membership.memberAlive(m)) {
                    if (log.isDebugEnabled()) {
                        log.debug((Object)("Mcast add member " + m));
                    }
                    t = new Thread(){

                        public void run() {
                            McastServiceImpl.this.service.memberAdded(m);
                        }
                    };
                }
                if (t != null) {
                    t.start();
                }
            }
        }
        catch (SocketTimeoutException socketTimeoutException) {
            // empty catch block
        }
        this.checkExpired();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void checkExpired() {
        Object object = this.expiredMutex;
        synchronized (object) {
            MemberImpl[] expired = this.membership.expire(this.timeToExpiration);
            for (int i = 0; i < expired.length; ++i) {
                final MemberImpl member = expired[i];
                if (log.isDebugEnabled()) {
                    log.debug((Object)("Mcast exipre  member " + expired[i]));
                }
                try {
                    Thread t = new Thread(){

                        public void run() {
                            McastServiceImpl.this.service.memberDisappeared(member);
                        }
                    };
                    t.start();
                    continue;
                }
                catch (Exception x) {
                    log.error((Object)"Unable to process member disappeared message.", (Throwable)x);
                }
            }
        }
    }

    public void send(boolean checkexpired) throws IOException {
        this.member.inc();
        if (log.isTraceEnabled()) {
            log.trace((Object)("Mcast send ping from member " + this.member));
        }
        byte[] data = this.member.getData();
        DatagramPacket p = new DatagramPacket(data, data.length);
        p.setAddress(this.address);
        p.setPort(this.port);
        this.socket.send(p);
        if (checkexpired) {
            this.checkExpired();
        }
    }

    public long getServiceStartTime() {
        return this.serviceStartTime;
    }

    public class SenderThread
    extends Thread {
        long time;

        public SenderThread(long time) {
            this.time = time;
            this.setName("Cluster-MembershipSender");
        }

        public void run() {
            while (McastServiceImpl.this.doRunSender) {
                try {
                    McastServiceImpl.this.send(true);
                }
                catch (Exception x) {
                    log.warn((Object)"Unable to send mcast message.", (Throwable)x);
                }
                try {
                    Thread.sleep(this.time);
                }
                catch (Exception exception) {}
            }
        }
    }

    public class ReceiverThread
    extends Thread {
        public ReceiverThread() {
            this.setName("Cluster-MembershipReceiver");
        }

        public void run() {
            while (McastServiceImpl.this.doRunReceiver) {
                try {
                    McastServiceImpl.this.receive();
                }
                catch (ArrayIndexOutOfBoundsException ax) {
                    if (!log.isDebugEnabled()) continue;
                    log.debug((Object)"Invalid member mcast package.", (Throwable)ax);
                }
                catch (Exception x) {
                    log.warn((Object)"Error receiving mcast package. Sleeping 500ms", (Throwable)x);
                    try {
                        Thread.sleep(500L);
                    }
                    catch (Exception exception) {}
                }
            }
        }
    }
}

