/*
 * Decompiled with CFR 0.152.
 */
package org.apache.axis2.jaxws.server.dispatcher;

import java.lang.reflect.Method;
import javax.jws.soap.SOAPBinding;
import org.apache.axis2.AxisFault;
import org.apache.axis2.jaxws.ExceptionFactory;
import org.apache.axis2.jaxws.context.utils.ContextUtils;
import org.apache.axis2.jaxws.core.MessageContext;
import org.apache.axis2.jaxws.core.util.MessageContextUtils;
import org.apache.axis2.jaxws.description.EndpointDescription;
import org.apache.axis2.jaxws.description.EndpointInterfaceDescription;
import org.apache.axis2.jaxws.description.OperationDescription;
import org.apache.axis2.jaxws.i18n.Messages;
import org.apache.axis2.jaxws.marshaller.MethodMarshaller;
import org.apache.axis2.jaxws.marshaller.factory.MethodMarshallerFactory;
import org.apache.axis2.jaxws.message.Message;
import org.apache.axis2.jaxws.message.Protocol;
import org.apache.axis2.jaxws.server.dispatcher.JavaDispatcher;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class JavaBeanDispatcher
extends JavaDispatcher {
    private static final Log log = LogFactory.getLog(JavaBeanDispatcher.class);
    private EndpointDescription endpointDesc = null;

    public JavaBeanDispatcher(Class implClass, Object serviceInstance) {
        super(implClass, serviceInstance);
    }

    public MessageContext invoke(MessageContext mc) throws Exception {
        Object response;
        Exception fault;
        boolean faultThrown;
        Method target;
        Object[] methodInputParams;
        MethodMarshaller methodMarshaller;
        Protocol requestProtocol;
        OperationDescription operationDesc;
        block9: {
            if (log.isDebugEnabled()) {
                log.debug((Object)("Preparing to invoke service endpoint implementation class: " + this.serviceImplClass.getName()));
            }
            this.initialize(mc);
            operationDesc = this.getOperationDescription(mc);
            ContextUtils.addWSDLProperties(mc);
            requestProtocol = mc.getMessage().getProtocol();
            methodMarshaller = this.getMethodMarshaller(mc.getMessage().getProtocol(), mc.getOperationDescription());
            methodInputParams = methodMarshaller.demarshalRequest(mc.getMessage(), mc.getOperationDescription());
            target = this.getJavaMethod(mc, this.serviceImplClass);
            if (log.isDebugEnabled()) {
                log.debug((Object)("JavaBeanDispatcher about to invoke using OperationDesc: " + operationDesc.toString()));
            }
            faultThrown = false;
            fault = null;
            response = null;
            try {
                response = this.invokeService(mc, target, this.serviceInstance, methodInputParams);
            }
            catch (Exception e) {
                faultThrown = true;
                fault = e;
                if (!log.isDebugEnabled()) break block9;
                log.debug((Object)("Exception invoking a method of " + this.serviceImplClass.toString() + " of instance " + this.serviceInstance.toString()));
                log.debug((Object)("Exception type thrown: " + e.getClass().getName()));
                log.debug((Object)("Method = " + target.toGenericString()));
                for (int i = 0; i < methodInputParams.length; ++i) {
                    String value = methodInputParams[i] == null ? "null" : methodInputParams[i].getClass().toString();
                    log.debug((Object)(" Argument[" + i + "] is " + value));
                }
            }
        }
        Message message = null;
        if (operationDesc.isOneWay()) {
            return null;
        }
        message = faultThrown ? methodMarshaller.marshalFaultResponse(fault, mc.getOperationDescription(), requestProtocol) : (target.getReturnType().getName().equals("void") ? methodMarshaller.marshalResponse(null, methodInputParams, mc.getOperationDescription(), requestProtocol) : methodMarshaller.marshalResponse(response, methodInputParams, mc.getOperationDescription(), requestProtocol));
        MessageContext responseMsgCtx = null;
        if (faultThrown) {
            responseMsgCtx = MessageContextUtils.createFaultMessageContext(mc);
            responseMsgCtx.setMessage(message);
            AxisFault axisFault = new AxisFault("An error was detected during JAXWS processing", responseMsgCtx.getAxisMessageContext(), (Throwable)fault);
            responseMsgCtx.setCausedByException(axisFault);
        } else {
            responseMsgCtx = MessageContextUtils.createResponseMessageContext(mc);
            responseMsgCtx.setMessage(message);
        }
        EndpointInterfaceDescription epInterfaceDesc = operationDesc.getEndpointInterfaceDescription();
        EndpointDescription epDesc = epInterfaceDesc.getEndpointDescription();
        String bindingType = epDesc.getBindingType();
        if (bindingType != null && (bindingType.equals("http://schemas.xmlsoap.org/wsdl/soap/http?mtom=true") || bindingType.equals("http://www.w3.org/2003/05/soap/bindings/HTTP/?mtom=true"))) {
            message.setMTOMEnabled(true);
        }
        return responseMsgCtx;
    }

    protected Object invokeService(MessageContext ctx, Method method, Object obj, Object[] args) throws Exception {
        return method.invoke(obj, args);
    }

    private void initialize(MessageContext mc) {
        mc.setOperationName(mc.getAxisMessageContext().getAxisOperation().getName());
        this.endpointDesc = mc.getEndpointDescription();
        mc.setOperationDescription(this.getOperationDescription(mc));
        String bindingType = this.endpointDesc.getBindingType();
        if (bindingType != null && (bindingType.equals("http://schemas.xmlsoap.org/wsdl/soap/http?mtom=true") || bindingType.equals("http://www.w3.org/2003/05/soap/bindings/HTTP/?mtom=true"))) {
            mc.getMessage().setMTOMEnabled(true);
        }
    }

    private OperationDescription getOperationDescription(MessageContext mc) {
        EndpointDescription ed = mc.getEndpointDescription();
        EndpointInterfaceDescription eid = ed.getEndpointInterfaceDescription();
        OperationDescription[] ops = eid.getDispatchableOperation(mc.getOperationName());
        if (ops == null || ops.length == 0) {
            throw ExceptionFactory.makeWebServiceException((String)("No operation found.  WSDL Operation name: " + mc.getOperationName()));
        }
        if (ops.length > 1) {
            throw ExceptionFactory.makeWebServiceException((String)("More than one operation found. Overloaded WSDL operations are not supported.  WSDL Operation name: " + mc.getOperationName()));
        }
        OperationDescription op = ops[0];
        if (log.isDebugEnabled()) {
            log.debug((Object)("wsdl operation: " + op.getName()));
            log.debug((Object)("   java method: " + op.getJavaMethodName()));
        }
        return op;
    }

    private MethodMarshaller getMethodMarshaller(Protocol protocol, OperationDescription operationDesc) {
        SOAPBinding.Style styleOnSEI = this.endpointDesc.getEndpointInterfaceDescription().getSoapBindingStyle();
        SOAPBinding.Style styleOnMethod = operationDesc.getSoapBindingStyle();
        if (styleOnMethod != null && styleOnSEI != styleOnMethod) {
            throw ExceptionFactory.makeWebServiceException((String)Messages.getMessage((String)"proxyErr2"));
        }
        return MethodMarshallerFactory.getMarshaller(operationDesc, false);
    }

    private Method getJavaMethod(MessageContext mc, Class serviceImplClass) {
        OperationDescription opDesc = mc.getOperationDescription();
        if (opDesc == null) {
            throw ExceptionFactory.makeWebServiceException((String)"Operation Description was not set");
        }
        Method returnMethod = opDesc.getMethodFromServiceImpl(serviceImplClass);
        if (returnMethod == null) {
            throw ExceptionFactory.makeWebServiceException((String)Messages.getMessage((String)"JavaBeanDispatcherErr1"));
        }
        return returnMethod;
    }
}

