/*
 * Decompiled with CFR 0.152.
 */
package org.apache.axis2.jaxws.message.attachments;

import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import javax.activation.DataHandler;
import javax.xml.bind.attachment.AttachmentUnmarshaller;
import org.apache.axis2.jaxws.ExceptionFactory;
import org.apache.axis2.jaxws.message.Message;
import org.apache.axis2.jaxws.utility.JavaUtils;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class JAXBAttachmentUnmarshaller
extends AttachmentUnmarshaller {
    private static final Log log = LogFactory.getLog(JAXBAttachmentUnmarshaller.class);
    private Message message;

    public JAXBAttachmentUnmarshaller(Message message) {
        this.message = message;
    }

    public boolean isXOPPackage() {
        boolean value = true;
        if (log.isDebugEnabled()) {
            log.debug((Object)("isXOPPackage returns " + value));
        }
        return value;
    }

    public byte[] getAttachmentAsByteArray(String cid) {
        DataHandler dh;
        if (log.isDebugEnabled()) {
            log.debug((Object)("Attempting to retrieve attachment [" + cid + "] as a byte[]"));
        }
        if ((dh = this.getAttachmentAsDataHandler(cid)) != null) {
            try {
                return this.convert(dh);
            }
            catch (IOException ioe) {
                if (log.isDebugEnabled()) {
                    log.debug((Object)("Exception occurred while getting the byte[] " + ioe));
                }
                throw ExceptionFactory.makeWebServiceException((Throwable)ioe);
            }
        }
        if (log.isDebugEnabled()) {
            log.debug((Object)"returning null byte[]");
        }
        return null;
    }

    public DataHandler getAttachmentAsDataHandler(String cid) {
        DataHandler dh;
        if (log.isDebugEnabled()) {
            log.debug((Object)("Attempting to retrieve attachment [" + cid + "] as a DataHandler"));
        }
        if ((dh = this.message.getDataHandler(cid)) != null) {
            return dh;
        }
        String cid2 = this.getNewCID(cid);
        if (log.isDebugEnabled()) {
            log.debug((Object)("A dataHandler was not found for [" + cid + "] trying [" + cid2 + "]"));
        }
        if ((dh = this.message.getDataHandler(cid2)) != null) {
            return dh;
        }
        throw ExceptionFactory.makeWebServiceException((String)("A data handler was not found for content id " + cid));
    }

    private String getNewCID(String cid) {
        String cid2 = cid;
        cid2 = JavaUtils.replace(cid2, "%3A", ":");
        cid2 = JavaUtils.replace(cid2, "%2F", "/");
        return cid2;
    }

    private byte[] convert(DataHandler dh) throws IOException {
        if (log.isDebugEnabled()) {
            log.debug((Object)("Reading byte[] from DataHandler " + dh));
        }
        InputStream is = dh.getInputStream();
        if (log.isDebugEnabled()) {
            log.debug((Object)("DataHandler InputStream " + is));
        }
        ByteArrayOutputStream baos = new ByteArrayOutputStream();
        byte[] b = new byte[1024];
        int num = is.read(b);
        if (log.isDebugEnabled() && num <= 0) {
            log.debug((Object)("DataHandler InputStream contains no data. num=" + num));
        }
        while (num > 0) {
            baos.write(b, 0, num);
            num = is.read(b);
        }
        return baos.toByteArray();
    }
}

