/*
 * Decompiled with CFR 0.152.
 */
package org.apache.axis2.jaxws.marshaller.impl.alt;

import java.io.BufferedWriter;
import java.io.IOException;
import java.io.PrintWriter;
import java.io.StringWriter;
import java.lang.reflect.Array;
import java.lang.reflect.Constructor;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.math.BigDecimal;
import java.math.BigInteger;
import java.security.PrivilegedActionException;
import java.security.PrivilegedExceptionAction;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.Date;
import java.util.GregorianCalendar;
import java.util.List;
import java.util.TreeSet;
import javax.activation.DataHandler;
import javax.jws.WebParam;
import javax.xml.bind.JAXBElement;
import javax.xml.namespace.QName;
import javax.xml.soap.MessageFactory;
import javax.xml.soap.SOAPBody;
import javax.xml.soap.SOAPFault;
import javax.xml.stream.XMLStreamException;
import javax.xml.ws.AsyncHandler;
import javax.xml.ws.Holder;
import javax.xml.ws.ProtocolException;
import javax.xml.ws.WebServiceException;
import javax.xml.ws.soap.SOAPFaultException;
import org.apache.axis2.java.security.AccessController;
import org.apache.axis2.jaxws.ExceptionFactory;
import org.apache.axis2.jaxws.description.AttachmentDescription;
import org.apache.axis2.jaxws.description.AttachmentType;
import org.apache.axis2.jaxws.description.EndpointDescription;
import org.apache.axis2.jaxws.description.FaultDescription;
import org.apache.axis2.jaxws.description.OperationDescription;
import org.apache.axis2.jaxws.description.ParameterDescription;
import org.apache.axis2.jaxws.description.ServiceDescription;
import org.apache.axis2.jaxws.i18n.Messages;
import org.apache.axis2.jaxws.marshaller.impl.alt.Attachment;
import org.apache.axis2.jaxws.marshaller.impl.alt.Element;
import org.apache.axis2.jaxws.marshaller.impl.alt.LegacyExceptionUtil;
import org.apache.axis2.jaxws.marshaller.impl.alt.PDElement;
import org.apache.axis2.jaxws.message.Block;
import org.apache.axis2.jaxws.message.Message;
import org.apache.axis2.jaxws.message.Protocol;
import org.apache.axis2.jaxws.message.XMLFault;
import org.apache.axis2.jaxws.message.XMLFaultReason;
import org.apache.axis2.jaxws.message.databinding.JAXBBlockContext;
import org.apache.axis2.jaxws.message.databinding.JAXBUtils;
import org.apache.axis2.jaxws.message.factory.JAXBBlockFactory;
import org.apache.axis2.jaxws.message.util.XMLFaultUtils;
import org.apache.axis2.jaxws.registry.FactoryRegistry;
import org.apache.axis2.jaxws.runtime.description.marshal.AnnotationDesc;
import org.apache.axis2.jaxws.runtime.description.marshal.FaultBeanDesc;
import org.apache.axis2.jaxws.runtime.description.marshal.MarshalServiceRuntimeDescription;
import org.apache.axis2.jaxws.runtime.description.marshal.MarshalServiceRuntimeDescriptionFactory;
import org.apache.axis2.jaxws.utility.ClassUtils;
import org.apache.axis2.jaxws.utility.ConvertUtils;
import org.apache.axis2.jaxws.utility.SAAJFactory;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class MethodMarshallerUtils {
    private static Log log = LogFactory.getLog(MethodMarshallerUtils.class);
    private static JAXBBlockFactory factory = (JAXBBlockFactory)FactoryRegistry.getFactory(JAXBBlockFactory.class);

    private MethodMarshallerUtils() {
    }

    static List<PDElement> getPDElements(MarshalServiceRuntimeDescription marshalDesc, ParameterDescription[] params, Object[] sigArguments, boolean isInput, boolean isDocLitWrapped, boolean isRPC) {
        ArrayList<PDElement> pdeList = new ArrayList<PDElement>();
        boolean index = false;
        for (int i = 0; i < params.length; ++i) {
            PDElement pde;
            Object value;
            ParameterDescription pd = params[i];
            if ((pd.getMode() != WebParam.Mode.IN || !isInput) && pd.getMode() != WebParam.Mode.INOUT && (pd.getMode() != WebParam.Mode.OUT || isInput) || MethodMarshallerUtils.isAsyncHandler(value = sigArguments[i])) continue;
            if (MethodMarshallerUtils.isHolder(value)) {
                value = ((Holder)value).value;
            }
            Class formalType = pd.getParameterActualType();
            QName qName = null;
            qName = pd.isHeader() ? new QName(pd.getTargetNamespace(), pd.getParameterName()) : (isDocLitWrapped ? new QName(pd.getTargetNamespace(), pd.getPartName()) : (isRPC ? new QName(pd.getPartName()) : new QName(pd.getTargetNamespace(), pd.getParameterName())));
            Element element = null;
            AttachmentDescription attachmentDesc = pd.getAttachmentDescription();
            if (attachmentDesc != null) {
                pde = MethodMarshallerUtils.createPDElementForAttachment(pd, qName, value, formalType);
                pdeList.add(pde);
                continue;
            }
            if (!marshalDesc.getAnnotationDesc(formalType).hasXmlRootElement()) {
                if (pd.isListType()) {
                    ArrayList<Object> list = new ArrayList<Object>();
                    if (formalType.isArray()) {
                        for (int count = 0; count < Array.getLength(value); ++count) {
                            Object obj = Array.get(value, count);
                            list.add(obj);
                        }
                    }
                    element = new Element(list, qName, List.class);
                } else {
                    element = new Element(value, qName, formalType);
                }
            } else {
                element = new Element(value, qName);
            }
            pde = new PDElement(pd, element, null);
            pdeList.add(pde);
        }
        return pdeList;
    }

    private static PDElement createPDElementForAttachment(ParameterDescription pd, QName qName, Object value, Class formalType) {
        AttachmentDescription attachmentDesc;
        AttachmentType attachmentType;
        if (log.isDebugEnabled()) {
            log.debug((Object)("Creating a PDElement for an attachment value: " + (value == null ? "null" : value.getClass().getName())));
            log.debug((Object)("ParameterDescription = " + pd.toString()));
        }
        if ((attachmentType = (attachmentDesc = pd.getAttachmentDescription()).getAttachmentType()) != AttachmentType.SWA) {
            throw ExceptionFactory.makeWebServiceException((String)"SWAREF and MTOM attachment parameters are not supported in this style/use.");
        }
        Attachment attachment = new Attachment(value, formalType, attachmentDesc);
        PDElement pde = new PDElement(pd, null, null, attachment);
        return pde;
    }

    static List<PDElement> getPDElements(ParameterDescription[] params, Message message, TreeSet<String> packages, boolean isInput, boolean hasReturnInBody, Class[] unmarshalByJavaType) throws XMLStreamException {
        ArrayList<PDElement> pdeList = new ArrayList<PDElement>();
        int totalBodyBlocks = 0;
        for (int i = 0; i < params.length; ++i) {
            ParameterDescription pd = params[i];
            if ((pd.getMode() != WebParam.Mode.IN || !isInput) && pd.getMode() != WebParam.Mode.INOUT && (pd.getMode() != WebParam.Mode.OUT || isInput) || pd.isHeader() || MethodMarshallerUtils.isSWAAttachment(pd)) continue;
            ++totalBodyBlocks;
        }
        if (!isInput && hasReturnInBody) {
            ++totalBodyBlocks;
        }
        int index = !isInput && hasReturnInBody ? 1 : 0;
        int swaIndex = 0;
        for (int i = 0; i < params.length; ++i) {
            ParameterDescription pd = params[i];
            if ((pd.getMode() != WebParam.Mode.IN || !isInput) && pd.getMode() != WebParam.Mode.INOUT && (pd.getMode() != WebParam.Mode.OUT || isInput)) continue;
            Block block = null;
            JAXBBlockContext context = new JAXBBlockContext(packages);
            AttachmentDescription attachmentDesc = pd.getAttachmentDescription();
            if (attachmentDesc == null) {
                if (unmarshalByJavaType != null && unmarshalByJavaType[i] != null) {
                    context.setProcessType(unmarshalByJavaType[i]);
                    context.setIsxmlList(pd.isListType());
                }
                if (pd.isHeader()) {
                    String localName = pd.getParameterName();
                    block = message.getHeaderBlock(pd.getTargetNamespace(), localName, context, factory);
                } else {
                    block = totalBodyBlocks > 1 ? message.getBodyBlock(index, context, factory) : message.getBodyBlock(context, factory);
                    ++index;
                }
                Element element = new Element(block.getBusinessObject(true), block.getQName());
                PDElement pde = new PDElement(pd, element, unmarshalByJavaType == null ? null : unmarshalByJavaType[i]);
                pdeList.add(pde);
                continue;
            }
            if (attachmentDesc.getAttachmentType() == AttachmentType.SWA) {
                String cid = message.getAttachmentID(swaIndex);
                DataHandler dh = message.getDataHandler(cid);
                Attachment attachment = new Attachment(dh, cid);
                PDElement pde = new PDElement(pd, null, null, attachment);
                pdeList.add(pde);
                ++swaIndex;
                continue;
            }
            throw ExceptionFactory.makeWebServiceException((String)"SWAREF and MTOM attachment parameters are not supported in this style/use.");
        }
        return pdeList;
    }

    static Object[] createRequestSignatureArgs(ParameterDescription[] pds, List<PDElement> pdeList) throws InstantiationException, IOException, IllegalAccessException, ClassNotFoundException {
        Object[] args = new Object[pds.length];
        int pdeIndex = 0;
        for (int i = 0; i < args.length; ++i) {
            PDElement pde = pdeIndex < pdeList.size() ? pdeList.get(pdeIndex) : null;
            ParameterDescription pd = pds[i];
            if (pde == null || pde.getParam() != pd) {
                if (pd.isHolderType()) {
                    args[i] = MethodMarshallerUtils.createHolder(pd.getParameterType(), null);
                    continue;
                }
                args[i] = null;
                continue;
            }
            Object value = null;
            value = pde.getAttachment() != null ? pde.getAttachment().getDataHandler() : pde.getElement().getTypeValue();
            ++pdeIndex;
            if (!ConvertUtils.isConvertable(value, pd.getParameterActualType())) {
                String objectClass = value == null ? "null" : value.getClass().getName();
                throw ExceptionFactory.makeWebServiceException((String)Messages.getMessage((String)"convertProblem", (String)objectClass, (String)pd.getParameterActualType().getName()));
            }
            value = ConvertUtils.convert(value, pd.getParameterActualType());
            args[i] = pd.isHolderType() ? MethodMarshallerUtils.createHolder(pd.getParameterType(), value) : value;
        }
        return args;
    }

    static void updateResponseSignatureArgs(ParameterDescription[] pds, List<PDElement> pdeList, Object[] signatureArgs) throws InstantiationException, IllegalAccessException, ClassNotFoundException {
        int pdeIndex = 0;
        for (int i = 0; i < pds.length; ++i) {
            PDElement pde = pdeIndex < pdeList.size() ? pdeList.get(pdeIndex) : null;
            ParameterDescription pd = pds[i];
            if (pde == null || pde.getParam() != pd) continue;
            Object value = null;
            value = pde.getAttachment() == null ? pde.getElement().getTypeValue() : pde.getAttachment().getDataHandler();
            ++pdeIndex;
            if (!ConvertUtils.isConvertable(value, pd.getParameterActualType())) {
                String objectClass = value == null ? "null" : value.getClass().getName();
                throw ExceptionFactory.makeWebServiceException((String)Messages.getMessage((String)"convertProblem", (String)objectClass, (String)pd.getParameterActualType().getName()));
            }
            value = ConvertUtils.convert(value, pd.getParameterActualType());
            if (!MethodMarshallerUtils.isHolder(signatureArgs[i])) continue;
            ((Holder)signatureArgs[i]).value = value;
        }
    }

    static void toMessage(List<PDElement> pdeList, Message message, TreeSet<String> packages) throws WebServiceException {
        int totalBodyBlocks = 0;
        for (int i = 0; i < pdeList.size(); ++i) {
            PDElement pde = pdeList.get(i);
            if (pde.getParam().isHeader() || pde.getElement() == null) continue;
            ++totalBodyBlocks;
        }
        int index = message.getNumBodyBlocks();
        for (int i = 0; i < pdeList.size(); ++i) {
            PDElement pde = pdeList.get(i);
            JAXBBlockContext context = new JAXBBlockContext(packages);
            Attachment attachment = pde.getAttachment();
            if (attachment == null) {
                if (pde.getByJavaTypeClass() != null) {
                    context.setProcessType(pde.getByJavaTypeClass());
                    if (pde.getParam() != null) {
                        context.setIsxmlList(pde.getParam().isListType());
                    }
                }
                Block block = factory.createFrom(pde.getElement().getElementValue(), (Object)context, pde.getElement().getQName());
                if (pde.getParam().isHeader()) {
                    QName qname = block.getQName();
                    message.setHeaderBlock(qname.getNamespaceURI(), qname.getLocalPart(), block);
                    continue;
                }
                if (totalBodyBlocks < 1) {
                    message.setBodyBlock(block);
                } else {
                    message.setBodyBlock(index, block);
                }
                ++index;
                continue;
            }
            AttachmentType type = pde.getParam().getAttachmentDescription().getAttachmentType();
            if (type == AttachmentType.SWA) {
                message.addDataHandler(attachment.getDataHandler(), attachment.getContentID());
                message.setDoingSWA(true);
                continue;
            }
            throw ExceptionFactory.makeWebServiceException((String)"SWAREF and MTOM attachment parameters are not supported in this style/use.");
        }
    }

    static void toMessage(Element returnElement, Class returnType, boolean isList, MarshalServiceRuntimeDescription marshalDesc, Message message, Class marshalByJavaTypeClass, boolean isHeader) throws WebServiceException {
        JAXBBlockContext context = new JAXBBlockContext(marshalDesc.getPackages());
        if (marshalByJavaTypeClass != null) {
            context.setProcessType(marshalByJavaTypeClass);
            context.setIsxmlList(isList);
        }
        Block block = factory.createFrom(returnElement.getElementValue(), (Object)context, returnElement.getQName());
        if (isHeader) {
            message.setHeaderBlock(returnElement.getQName().getNamespaceURI(), returnElement.getQName().getLocalPart(), block);
        } else {
            message.setBodyBlock(block);
        }
    }

    static Element getReturnElement(TreeSet<String> packages, Message message, Class unmarshalByJavaTypeClass, boolean isList, boolean isHeader, String headerNS, String headerLocalPart, boolean hasOutputBodyParams) throws WebServiceException, XMLStreamException {
        JAXBBlockContext context = new JAXBBlockContext(packages);
        if (unmarshalByJavaTypeClass != null && !isHeader) {
            context.setProcessType(unmarshalByJavaTypeClass);
            context.setIsxmlList(isList);
        }
        Block block = null;
        block = isHeader ? message.getHeaderBlock(headerNS, headerLocalPart, context, factory) : (hasOutputBodyParams ? message.getBodyBlock(0, context, factory) : message.getBodyBlock(context, factory));
        Element returnElement = new Element(block.getBusinessObject(true), block.getQName());
        return returnElement;
    }

    static void marshalFaultResponse(Throwable throwable, MarshalServiceRuntimeDescription marshalDesc, OperationDescription operationDesc, Message message) {
        Throwable t = ClassUtils.getRootCause(throwable);
        if (log.isDebugEnabled()) {
            log.debug((Object)("Marshal Throwable =" + throwable.getClass().getName()));
            log.debug((Object)("  rootCause =" + t.getClass().getName()));
            log.debug((Object)("  exception=" + t.toString()));
            log.debug((Object)("  stack=" + MethodMarshallerUtils.stackToString(t)));
        }
        XMLFault xmlfault = null;
        try {
            FaultDescription fd = operationDesc.resolveFaultByExceptionName(t.getClass().getCanonicalName());
            if (fd != null) {
                String text;
                if (log.isErrorEnabled()) {
                    log.debug((Object)"Marshal as a Service Exception");
                }
                JAXBBlockContext context = new JAXBBlockContext(marshalDesc.getPackages());
                Object faultBeanObject = null;
                FaultBeanDesc faultBeanDesc = marshalDesc.getFaultBeanDesc(fd);
                String faultInfo = fd.getFaultInfo();
                if (faultInfo == null || faultInfo.length() == 0) {
                    faultBeanObject = LegacyExceptionUtil.createFaultBean(t, fd, marshalDesc);
                } else {
                    Method getFaultInfo = t.getClass().getMethod("getFaultInfo", null);
                    faultBeanObject = getFaultInfo.invoke((Object)t, null);
                }
                if (log.isErrorEnabled()) {
                    log.debug((Object)("The faultBean type is" + faultBeanObject.getClass().getName()));
                }
                if (faultBeanObject == t || context.getConstructionType() != JAXBUtils.CONSTRUCTION_TYPE.BY_CONTEXT_PATH && MethodMarshallerUtils.isNotJAXBRootElement(faultBeanObject.getClass(), marshalDesc)) {
                    context.setProcessType(faultBeanObject.getClass());
                }
                QName faultBeanQName = new QName(faultBeanDesc.getFaultBeanNamespace(), faultBeanDesc.getFaultBeanLocalName());
                if (!marshalDesc.getAnnotationDesc(faultBeanObject.getClass()).hasXmlRootElement()) {
                    faultBeanObject = new JAXBElement(faultBeanQName, faultBeanObject.getClass(), faultBeanObject);
                }
                Block[] detailBlocks = new Block[]{factory.createFrom(faultBeanObject, (Object)context, faultBeanQName)};
                if (log.isErrorEnabled()) {
                    log.debug((Object)"Create the xmlFault for the Service Exception");
                }
                if ((text = t.getMessage()) == null || text.length() == 0) {
                    text = t.toString();
                }
                xmlfault = new XMLFault(null, new XMLFaultReason(text), detailBlocks);
            } else {
                xmlfault = MethodMarshallerUtils.createXMLFaultFromSystemException(t);
            }
        }
        catch (Throwable e) {
            if (log.isDebugEnabled()) {
                log.debug((Object)("An exception (" + e + ") occurred while marshalling exception (" + t + ")"));
            }
            WebServiceException wse = ExceptionFactory.makeWebServiceException((Throwable)e);
            xmlfault = MethodMarshallerUtils.createXMLFaultFromSystemException(wse);
        }
        message.setXMLFault(xmlfault);
    }

    public static XMLFault createXMLFaultFromSystemException(Throwable t) {
        try {
            XMLFault xmlfault = null;
            if (t instanceof SOAPFaultException) {
                SOAPFaultException sfe;
                SOAPFault soapFault;
                if (log.isErrorEnabled()) {
                    log.debug((Object)"Marshal SOAPFaultException");
                }
                xmlfault = (soapFault = (sfe = (SOAPFaultException)t).getFault()) == null ? new XMLFault(null, new XMLFaultReason(t.toString())) : XMLFaultUtils.createXMLFault(soapFault);
            } else if (t instanceof WebServiceException) {
                WebServiceException wse;
                String text;
                if (log.isErrorEnabled()) {
                    log.debug((Object)"Marshal as a WebServiceException");
                }
                if ((text = (wse = (WebServiceException)t).getMessage()) == null || text.length() == 0) {
                    text = wse.toString();
                }
                xmlfault = new XMLFault(null, new XMLFaultReason(text));
            } else {
                String text;
                if (log.isErrorEnabled()) {
                    log.debug((Object)"Marshal as a unchecked System Exception");
                }
                if ((text = t.getMessage()) == null || text.length() == 0) {
                    text = t.toString();
                }
                xmlfault = new XMLFault(null, new XMLFaultReason(text));
            }
            return xmlfault;
        }
        catch (Throwable e) {
            try {
                String text;
                if (log.isDebugEnabled()) {
                    log.debug((Object)("An exception (" + e + ") occurred while marshalling exception (" + t + ")"));
                }
                if ((text = e.getMessage()) == null || text.length() == 0) {
                    text = e.toString();
                }
                WebServiceException wse = ExceptionFactory.makeWebServiceException((Throwable)e);
                return new XMLFault(null, new XMLFaultReason(text));
            }
            catch (Exception e2) {
                throw ExceptionFactory.makeWebServiceException((Throwable)e2);
            }
        }
    }

    static Throwable demarshalFaultResponse(OperationDescription operationDesc, MarshalServiceRuntimeDescription marshalDesc, Message message) throws WebServiceException, ClassNotFoundException, IllegalAccessException, InstantiationException, XMLStreamException, InvocationTargetException, NoSuchMethodException {
        FaultBeanDesc faultBeanDesc;
        FaultDescription fd;
        int i;
        Object exception = null;
        XMLFault xmlfault = message.getXMLFault();
        Block[] detailBlocks = xmlfault.getDetailBlocks();
        QName elementQName = null;
        if (detailBlocks != null && detailBlocks.length == 1) {
            elementQName = detailBlocks[0].getQName();
        }
        FaultDescription faultDesc = null;
        if (elementQName != null) {
            for (i = 0; i < operationDesc.getFaultDescriptions().length && faultDesc == null; ++i) {
                fd = operationDesc.getFaultDescriptions()[i];
                faultBeanDesc = marshalDesc.getFaultBeanDesc(fd);
                QName tryQName = new QName(faultBeanDesc.getFaultBeanNamespace(), faultBeanDesc.getFaultBeanLocalName());
                if (log.isErrorEnabled()) {
                    log.debug((Object)("  FaultDescription qname is (" + tryQName + ") and detail element qname is (" + elementQName + ")"));
                }
                if (!elementQName.equals(tryQName)) continue;
                faultDesc = fd;
            }
        }
        if (faultDesc == null && elementQName != null) {
            for (i = 0; i < operationDesc.getFaultDescriptions().length && faultDesc == null; ++i) {
                fd = operationDesc.getFaultDescriptions()[i];
                faultBeanDesc = marshalDesc.getFaultBeanDesc(fd);
                String tryName = faultBeanDesc.getFaultBeanLocalName();
                if (!elementQName.getLocalPart().equals(tryName)) continue;
                faultDesc = fd;
            }
        }
        if (faultDesc == null) {
            exception = MethodMarshallerUtils.createSystemException(xmlfault, message);
        } else {
            Block jaxbBlock;
            Object faultBeanObject;
            if (log.isErrorEnabled()) {
                log.debug((Object)("Ready to demarshal service exception.  The detail entry name is " + elementQName));
            }
            FaultBeanDesc faultBeanDesc2 = marshalDesc.getFaultBeanDesc(faultDesc);
            boolean isLegacy = faultDesc.getFaultInfo() == null || faultDesc.getFaultInfo().length() == 0;
            JAXBBlockContext blockContext = new JAXBBlockContext(marshalDesc.getPackages());
            Class faultBeanFormalClass = MethodMarshallerUtils.loadClass(faultBeanDesc2.getFaultBeanClassName());
            if (blockContext.getConstructionType() != JAXBUtils.CONSTRUCTION_TYPE.BY_CONTEXT_PATH && MethodMarshallerUtils.isNotJAXBRootElement(faultBeanFormalClass, marshalDesc)) {
                blockContext.setProcessType(faultBeanFormalClass);
            }
            if ((faultBeanObject = (jaxbBlock = factory.createFrom(detailBlocks[0], blockContext)).getBusinessObject(true)) instanceof JAXBElement) {
                faultBeanObject = ((JAXBElement)faultBeanObject).getValue();
            }
            if (log.isErrorEnabled()) {
                log.debug((Object)"Unmarshalled the detail element into a JAXB object");
            }
            Class exceptionClass = MethodMarshallerUtils.loadClass(faultDesc.getExceptionClassName());
            if (log.isErrorEnabled()) {
                log.debug((Object)("Found FaultDescription.  The exception name is " + exceptionClass.getName()));
            }
            exception = MethodMarshallerUtils.createServiceException(xmlfault.getReason().getText(), exceptionClass, faultBeanObject, faultBeanFormalClass, marshalDesc, isLegacy);
        }
        return exception;
    }

    static int numOutputBodyParams(ParameterDescription[] pds) {
        int count = 0;
        for (int i = 0; i < pds.length; ++i) {
            if (pds[i].isHeader() || pds[i].getMode() != WebParam.Mode.INOUT && pds[i].getMode() != WebParam.Mode.OUT) continue;
            ++count;
        }
        return count;
    }

    static boolean isAsyncHandler(Object value) {
        return value instanceof AsyncHandler;
    }

    static boolean isHolder(Object value) {
        return value != null && Holder.class.isAssignableFrom(value.getClass());
    }

    static <T> Holder<T> createHolder(Class paramType, T value) throws IllegalAccessException, InstantiationException, ClassNotFoundException {
        if (Holder.class.isAssignableFrom(paramType)) {
            Holder holder = (Holder)paramType.newInstance();
            holder.value = value;
            return holder;
        }
        return null;
    }

    static Class loadClass(String className) throws ClassNotFoundException {
        Class cls = ClassUtils.getPrimitiveClass(className);
        if (cls == null) {
            cls = MethodMarshallerUtils.forName(className, true, MethodMarshallerUtils.getContextClassLoader());
        }
        return cls;
    }

    private static Class forName(final String className, final boolean initialize, final ClassLoader classLoader) {
        Class cl = null;
        try {
            cl = (Class)AccessController.doPrivileged((PrivilegedExceptionAction)new PrivilegedExceptionAction(){

                public Object run() throws ClassNotFoundException {
                    Class<?> cls = ClassUtils.getPrimitiveClass(className);
                    if (cls == null) {
                        cls = Class.forName(className, initialize, classLoader);
                    }
                    return cls;
                }
            });
        }
        catch (PrivilegedActionException e) {
            if (log.isDebugEnabled()) {
                log.debug((Object)("Exception thrown from AccessController: " + e));
            }
            throw ExceptionFactory.makeWebServiceException((Throwable)e.getException());
        }
        return cl;
    }

    private static ClassLoader getContextClassLoader() {
        ClassLoader cl = null;
        try {
            cl = (ClassLoader)AccessController.doPrivileged((PrivilegedExceptionAction)new PrivilegedExceptionAction(){

                public Object run() throws ClassNotFoundException {
                    return Thread.currentThread().getContextClassLoader();
                }
            });
        }
        catch (PrivilegedActionException e) {
            if (log.isDebugEnabled()) {
                log.debug((Object)("Exception thrown from AccessController: " + e));
            }
            throw ExceptionFactory.makeWebServiceException((Throwable)e.getException());
        }
        return cl;
    }

    private static Exception createServiceException(String message, Class exceptionclass, Object bean, Class beanFormalType, MarshalServiceRuntimeDescription marshalDesc, boolean isLegacyException) throws InvocationTargetException, IllegalAccessException, InstantiationException, NoSuchMethodException {
        if (log.isDebugEnabled()) {
            log.debug((Object)("Constructing JAX-WS Exception:" + exceptionclass));
        }
        Exception exception = null;
        if (isLegacyException) {
            exception = LegacyExceptionUtil.createFaultException(exceptionclass, bean, marshalDesc);
        } else {
            Constructor constructor = exceptionclass.getConstructor(String.class, beanFormalType);
            exception = (Exception)constructor.newInstance(message, bean);
        }
        return exception;
    }

    public static ProtocolException createSystemException(XMLFault xmlFault, Message message) {
        ProtocolException e = null;
        Protocol protocol = message.getProtocol();
        String text = xmlFault.getReason().getText();
        if (protocol == Protocol.soap11 || protocol == Protocol.soap12) {
            if (log.isDebugEnabled()) {
                log.debug((Object)("Constructing SOAPFaultException for " + text));
            }
            String protocolNS = protocol == Protocol.soap11 ? "http://schemas.xmlsoap.org/soap/envelope/" : "http://www.w3.org/2003/05/soap-envelope";
            try {
                MessageFactory mf = SAAJFactory.createMessageFactory(protocolNS);
                SOAPBody body = mf.createMessage().getSOAPBody();
                SOAPFault soapFault = XMLFaultUtils.createSAAJFault(xmlFault, body);
                e = new SOAPFaultException(soapFault);
            }
            catch (Exception ex) {
                if (log.isDebugEnabled()) {
                    log.debug((Object)"Exception occurred during fault processing:", (Throwable)ex);
                }
                e = ExceptionFactory.makeProtocolException((String)text, null);
            }
        } else if (protocol == Protocol.rest) {
            if (log.isDebugEnabled()) {
                log.debug((Object)("Constructing ProtocolException for " + text));
            }
            e = ExceptionFactory.makeProtocolException((String)text, null);
        } else if (protocol == Protocol.unknown) {
            if (log.isDebugEnabled()) {
                log.debug((Object)("Constructing ProtocolException for " + text));
            }
            e = ExceptionFactory.makeProtocolException((String)text, null);
        }
        return e;
    }

    static MarshalServiceRuntimeDescription getMarshalDesc(EndpointDescription ed) {
        ServiceDescription sd = ed.getServiceDescription();
        return MarshalServiceRuntimeDescriptionFactory.get(sd);
    }

    static boolean isNotJAXBRootElement(Class cls, MarshalServiceRuntimeDescription marshalDesc) {
        if (cls == String.class || cls.isPrimitive() || cls == Calendar.class || cls == byte[].class || cls == GregorianCalendar.class || cls == Date.class || cls == BigInteger.class || cls == BigDecimal.class) {
            return true;
        }
        AnnotationDesc aDesc = marshalDesc.getAnnotationDesc(cls);
        if (aDesc != null) {
            return aDesc.getXmlRootElementName() == null;
        }
        return true;
    }

    public static String stackToString(Throwable e) {
        StringWriter sw = new StringWriter();
        BufferedWriter bw = new BufferedWriter(sw);
        PrintWriter pw = new PrintWriter(bw);
        e.printStackTrace(pw);
        pw.close();
        return sw.getBuffer().toString();
    }

    static boolean isSWAAttachment(ParameterDescription pd) {
        return pd.getAttachmentDescription() != null && pd.getAttachmentDescription().getAttachmentType() == AttachmentType.SWA;
    }
}

