/*
 * Decompiled with CFR 0.152.
 */
package org.apache.axis2.jaxws.marshaller.impl.alt;

import java.util.List;
import java.util.TreeSet;
import javax.jws.soap.SOAPBinding;
import javax.xml.namespace.QName;
import javax.xml.ws.WebServiceException;
import org.apache.axis2.jaxws.ExceptionFactory;
import org.apache.axis2.jaxws.description.EndpointDescription;
import org.apache.axis2.jaxws.description.EndpointInterfaceDescription;
import org.apache.axis2.jaxws.description.OperationDescription;
import org.apache.axis2.jaxws.description.ParameterDescription;
import org.apache.axis2.jaxws.i18n.Messages;
import org.apache.axis2.jaxws.marshaller.MethodMarshaller;
import org.apache.axis2.jaxws.marshaller.impl.alt.Element;
import org.apache.axis2.jaxws.marshaller.impl.alt.MethodMarshallerUtils;
import org.apache.axis2.jaxws.marshaller.impl.alt.PDElement;
import org.apache.axis2.jaxws.message.Message;
import org.apache.axis2.jaxws.message.Protocol;
import org.apache.axis2.jaxws.message.factory.MessageFactory;
import org.apache.axis2.jaxws.registry.FactoryRegistry;
import org.apache.axis2.jaxws.runtime.description.marshal.MarshalServiceRuntimeDescription;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class DocLitWrappedMinimalMethodMarshaller
implements MethodMarshaller {
    private static Log log = LogFactory.getLog(DocLitWrappedMinimalMethodMarshaller.class);

    public Message marshalRequest(Object[] signatureArguments, OperationDescription operationDesc) throws WebServiceException {
        EndpointInterfaceDescription ed = operationDesc.getEndpointInterfaceDescription();
        EndpointDescription endpointDesc = ed.getEndpointDescription();
        Protocol protocol = Protocol.getProtocolForBinding(endpointDesc.getClientBindingID());
        try {
            ParameterDescription[] pds = operationDesc.getParameterDescriptions();
            MarshalServiceRuntimeDescription marshalDesc = MethodMarshallerUtils.getMarshalDesc(endpointDesc);
            TreeSet<String> packages = marshalDesc.getPackages();
            if (pds.length > 0) {
                if (signatureArguments == null) {
                    throw ExceptionFactory.makeWebServiceException((String)Messages.getMessage((String)"NullParamErr1", (String)"Input", (String)operationDesc.getJavaMethodName(), (String)"doc/lit"));
                }
                if (signatureArguments != null) {
                    for (Object argument : signatureArguments) {
                        if (argument != null) continue;
                        throw ExceptionFactory.makeWebServiceException((String)Messages.getMessage((String)"NullParamErr1", (String)"Input", (String)operationDesc.getJavaMethodName(), (String)"doc/lit"));
                    }
                }
            }
            MessageFactory mf = (MessageFactory)FactoryRegistry.getFactory(MessageFactory.class);
            Message m = mf.create(protocol);
            m.setStyle(SOAPBinding.Style.DOCUMENT);
            m.setIndirection(1);
            m.setOperationElement(DocLitWrappedMinimalMethodMarshaller.getRequestWrapperQName(operationDesc));
            List<PDElement> pdeList = MethodMarshallerUtils.getPDElements(marshalDesc, pds, signatureArguments, true, true, true);
            for (PDElement pde : pdeList) {
                ParameterDescription pd = pde.getParam();
                Class type = pd.getParameterActualType();
                pde.setByJavaTypeClass(type);
            }
            MethodMarshallerUtils.toMessage(pdeList, m, packages);
            return m;
        }
        catch (Exception e) {
            throw ExceptionFactory.makeWebServiceException((Throwable)e);
        }
    }

    public Object[] demarshalRequest(Message message, OperationDescription operationDesc) throws WebServiceException {
        EndpointInterfaceDescription ed = operationDesc.getEndpointInterfaceDescription();
        EndpointDescription endpointDesc = ed.getEndpointDescription();
        try {
            ParameterDescription[] pds = operationDesc.getParameterDescriptions();
            MarshalServiceRuntimeDescription marshalDesc = MethodMarshallerUtils.getMarshalDesc(endpointDesc);
            TreeSet<String> packages = marshalDesc.getPackages();
            message.setStyle(SOAPBinding.Style.DOCUMENT);
            message.setIndirection(1);
            Class[] javaTypes = new Class[pds.length];
            for (int i = 0; i < pds.length; ++i) {
                ParameterDescription pd = pds[i];
                javaTypes[i] = pd.getParameterActualType();
            }
            List<PDElement> pvList = MethodMarshallerUtils.getPDElements(pds, message, packages, true, false, javaTypes);
            Object[] sigArguments = MethodMarshallerUtils.createRequestSignatureArgs(pds, pvList);
            if (sigArguments != null) {
                for (Object argument : sigArguments) {
                    if (argument != null) continue;
                    throw ExceptionFactory.makeWebServiceException((String)Messages.getMessage((String)"NullParamErr1", (String)"Input", (String)operationDesc.getJavaMethodName(), (String)"rpc/lit"));
                }
            }
            return sigArguments;
        }
        catch (Exception e) {
            throw ExceptionFactory.makeWebServiceException((Throwable)e);
        }
    }

    public Message marshalResponse(Object returnObject, Object[] signatureArgs, OperationDescription operationDesc, Protocol protocol) throws WebServiceException {
        EndpointInterfaceDescription ed = operationDesc.getEndpointInterfaceDescription();
        EndpointDescription endpointDesc = ed.getEndpointDescription();
        if (protocol == null) {
            protocol = Protocol.getProtocolForBinding(endpointDesc.getBindingType());
        }
        try {
            ParameterDescription[] pds = operationDesc.getParameterDescriptions();
            MarshalServiceRuntimeDescription marshalDesc = MethodMarshallerUtils.getMarshalDesc(endpointDesc);
            TreeSet<String> packages = marshalDesc.getPackages();
            MessageFactory mf = (MessageFactory)FactoryRegistry.getFactory(MessageFactory.class);
            Message m = mf.create(protocol);
            m.setStyle(SOAPBinding.Style.DOCUMENT);
            m.setIndirection(1);
            QName responseOp = DocLitWrappedMinimalMethodMarshaller.getResponseWrapperQName(operationDesc);
            m.setOperationElement(responseOp);
            Class returnType = operationDesc.getResultActualType();
            String returnNS = null;
            String returnLocalPart = null;
            if (operationDesc.isResultHeader()) {
                returnNS = operationDesc.getResultTargetNamespace();
                returnLocalPart = operationDesc.getResultName();
            } else {
                returnNS = operationDesc.getResultTargetNamespace();
                returnLocalPart = operationDesc.getResultPartName();
            }
            if (returnType != Void.TYPE) {
                if (returnObject == null) {
                    throw ExceptionFactory.makeWebServiceException((String)Messages.getMessage((String)"NullParamErr1", (String)"Return", (String)operationDesc.getJavaMethodName(), (String)"rpc/lit"));
                }
                Element returnElement = null;
                QName returnQName = new QName(returnNS, returnLocalPart);
                returnElement = marshalDesc.getAnnotationDesc(returnType).hasXmlRootElement() ? new Element(returnObject, returnQName) : new Element(returnObject, returnQName, returnType);
                MethodMarshallerUtils.toMessage(returnElement, returnType, operationDesc.isListType(), marshalDesc, m, returnType, operationDesc.isResultHeader());
            }
            List<PDElement> pdeList = MethodMarshallerUtils.getPDElements(marshalDesc, pds, signatureArgs, false, true, false);
            for (PDElement pde : pdeList) {
                ParameterDescription pd = pde.getParam();
                Class type = pd.getParameterActualType();
                pde.setByJavaTypeClass(type);
            }
            MethodMarshallerUtils.toMessage(pdeList, m, packages);
            return m;
        }
        catch (Exception e) {
            throw ExceptionFactory.makeWebServiceException((Throwable)e);
        }
    }

    public Object demarshalResponse(Message message, Object[] signatureArgs, OperationDescription operationDesc) throws WebServiceException {
        EndpointInterfaceDescription ed = operationDesc.getEndpointInterfaceDescription();
        EndpointDescription endpointDesc = ed.getEndpointDescription();
        try {
            ParameterDescription[] pds = operationDesc.getParameterDescriptions();
            MarshalServiceRuntimeDescription marshalDesc = MethodMarshallerUtils.getMarshalDesc(endpointDesc);
            TreeSet<String> packages = marshalDesc.getPackages();
            message.setStyle(SOAPBinding.Style.DOCUMENT);
            message.setIndirection(1);
            Class returnType = operationDesc.getResultActualType();
            Object returnValue = null;
            boolean hasReturnInBody = false;
            if (returnType != Void.TYPE) {
                Element returnElement = null;
                if (operationDesc.isResultHeader()) {
                    returnElement = MethodMarshallerUtils.getReturnElement(packages, message, returnType, operationDesc.isListType(), true, operationDesc.getResultTargetNamespace(), operationDesc.getResultPartName(), MethodMarshallerUtils.numOutputBodyParams(pds) > 0);
                } else {
                    returnElement = MethodMarshallerUtils.getReturnElement(packages, message, returnType, operationDesc.isListType(), false, null, null, MethodMarshallerUtils.numOutputBodyParams(pds) > 0);
                    hasReturnInBody = true;
                }
                returnValue = returnElement.getTypeValue();
                if (returnValue == null) {
                    throw ExceptionFactory.makeWebServiceException((String)Messages.getMessage((String)"NullParamErr1", (String)"Return", (String)operationDesc.getJavaMethodName(), (String)"rpc/lit"));
                }
            }
            Class[] javaTypes = new Class[pds.length];
            for (int i = 0; i < pds.length; ++i) {
                Class type;
                ParameterDescription pd = pds[i];
                javaTypes[i] = type = pd.getParameterActualType();
            }
            List<PDElement> pvList = MethodMarshallerUtils.getPDElements(pds, message, packages, false, hasReturnInBody, javaTypes);
            MethodMarshallerUtils.updateResponseSignatureArgs(pds, pvList, signatureArgs);
            return returnValue;
        }
        catch (Exception e) {
            throw ExceptionFactory.makeWebServiceException((Throwable)e);
        }
    }

    public Message marshalFaultResponse(Throwable throwable, OperationDescription operationDesc, Protocol protocol) throws WebServiceException {
        EndpointInterfaceDescription ed = operationDesc.getEndpointInterfaceDescription();
        EndpointDescription endpointDesc = ed.getEndpointDescription();
        MarshalServiceRuntimeDescription marshalDesc = MethodMarshallerUtils.getMarshalDesc(endpointDesc);
        TreeSet<String> packages = marshalDesc.getPackages();
        if (protocol == null) {
            protocol = Protocol.getProtocolForBinding(endpointDesc.getBindingType());
        }
        try {
            MessageFactory mf = (MessageFactory)FactoryRegistry.getFactory(MessageFactory.class);
            Message m = mf.create(protocol);
            MethodMarshallerUtils.marshalFaultResponse(throwable, marshalDesc, operationDesc, m);
            return m;
        }
        catch (Exception e) {
            throw ExceptionFactory.makeWebServiceException((Throwable)e);
        }
    }

    public Throwable demarshalFaultResponse(Message message, OperationDescription operationDesc) throws WebServiceException {
        EndpointInterfaceDescription ed = operationDesc.getEndpointInterfaceDescription();
        EndpointDescription endpointDesc = ed.getEndpointDescription();
        MarshalServiceRuntimeDescription marshalDesc = MethodMarshallerUtils.getMarshalDesc(endpointDesc);
        try {
            Throwable t = MethodMarshallerUtils.demarshalFaultResponse(operationDesc, marshalDesc, message);
            return t;
        }
        catch (Exception e) {
            throw ExceptionFactory.makeWebServiceException((Throwable)e);
        }
    }

    private static QName getRequestWrapperQName(OperationDescription opDesc) {
        QName qName = opDesc.getName();
        String localPart = opDesc.getRequestWrapperLocalName();
        String uri = opDesc.getRequestWrapperTargetNamespace();
        String prefix = "dlwmin";
        qName = new QName(uri, localPart, prefix);
        return qName;
    }

    private static QName getResponseWrapperQName(OperationDescription opDesc) {
        QName qName = opDesc.getName();
        String localPart = opDesc.getResponseWrapperLocalName();
        String uri = opDesc.getResponseWrapperTargetNamespace();
        String prefix = "dlwmin";
        qName = new QName(uri, localPart, prefix);
        return qName;
    }
}

