/*
 * Decompiled with CFR 0.152.
 */
package org.apache.axis2.jaxws.context;

import java.security.Principal;
import javax.servlet.http.HttpServletRequest;
import javax.xml.ws.WebServiceContext;
import javax.xml.ws.handler.MessageContext;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class WebServiceContextImpl
implements WebServiceContext {
    private static final Log log = LogFactory.getLog(WebServiceContext.class);
    private MessageContext soapMessageContext;

    public MessageContext getMessageContext() {
        return this.soapMessageContext;
    }

    public Principal getUserPrincipal() {
        if (this.soapMessageContext != null) {
            HttpServletRequest request = (HttpServletRequest)this.soapMessageContext.get((Object)"javax.xml.ws.servlet.request");
            if (request != null) {
                if (log.isDebugEnabled()) {
                    log.debug((Object)"Access to the user Principal was requested.");
                }
                return request.getUserPrincipal();
            }
            if (log.isDebugEnabled()) {
                log.debug((Object)"No HttpServletRequest object was found, so no Principal can be found.");
            }
        }
        return null;
    }

    public boolean isUserInRole(String user) {
        if (this.soapMessageContext != null) {
            HttpServletRequest request = (HttpServletRequest)this.soapMessageContext.get((Object)"javax.xml.ws.servlet.request");
            if (request != null) {
                if (log.isDebugEnabled()) {
                    log.debug((Object)"Checking to see if the user in the role.");
                }
                return request.isUserInRole(user);
            }
            if (log.isDebugEnabled()) {
                log.debug((Object)"No HttpServletRequest object was found, so no role check can be performed.");
            }
        }
        return false;
    }

    public void setSoapMessageContext(MessageContext soapMessageContext) {
        this.soapMessageContext = soapMessageContext;
    }
}

