/*
 * Decompiled with CFR 0.152.
 */
package org.apache.axis2.clustering.tribes;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Random;
import org.apache.axiom.om.OMElement;
import org.apache.axis2.AxisFault;
import org.apache.axis2.clustering.ClusterManager;
import org.apache.axis2.clustering.ClusteringCommand;
import org.apache.axis2.clustering.ClusteringFault;
import org.apache.axis2.clustering.RequestBlockingHandler;
import org.apache.axis2.clustering.configuration.ConfigurationManager;
import org.apache.axis2.clustering.configuration.DefaultConfigurationManager;
import org.apache.axis2.clustering.context.ClusteringContextListener;
import org.apache.axis2.clustering.context.ContextManager;
import org.apache.axis2.clustering.context.DefaultContextManager;
import org.apache.axis2.clustering.control.GetConfigurationCommand;
import org.apache.axis2.clustering.control.GetStateCommand;
import org.apache.axis2.clustering.tribes.ChannelListener;
import org.apache.axis2.clustering.tribes.ChannelSender;
import org.apache.axis2.clustering.tribes.TribesControlCommandProcessor;
import org.apache.axis2.clustering.tribes.TribesMembershipListener;
import org.apache.axis2.clustering.tribes.TribesUtil;
import org.apache.axis2.context.ConfigurationContext;
import org.apache.axis2.context.ContextListener;
import org.apache.axis2.description.HandlerDescription;
import org.apache.axis2.description.Parameter;
import org.apache.axis2.description.PhaseRule;
import org.apache.axis2.engine.AxisConfiguration;
import org.apache.axis2.engine.DispatchPhase;
import org.apache.axis2.engine.Handler;
import org.apache.axis2.engine.Phase;
import org.apache.catalina.tribes.Channel;
import org.apache.catalina.tribes.ChannelException;
import org.apache.catalina.tribes.ChannelInterceptor;
import org.apache.catalina.tribes.ManagedChannel;
import org.apache.catalina.tribes.Member;
import org.apache.catalina.tribes.MembershipListener;
import org.apache.catalina.tribes.group.GroupChannel;
import org.apache.catalina.tribes.group.interceptors.DomainFilterInterceptor;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class TribesClusterManager
implements ClusterManager {
    private static final Log log = LogFactory.getLog((Class)TribesClusterManager.class);
    private DefaultConfigurationManager configurationManager;
    private DefaultContextManager contextManager;
    private HashMap parameters = new HashMap();
    private ManagedChannel channel;
    private ConfigurationContext configurationContext;
    private TribesControlCommandProcessor controlCmdProcessor = new TribesControlCommandProcessor(this.configurationContext);
    private ChannelListener channelListener;

    public ContextManager getContextManager() {
        return this.contextManager;
    }

    public ConfigurationManager getConfigurationManager() {
        return this.configurationManager;
    }

    public void init() throws ClusteringFault {
        HandlerDescription handlerDesc;
        PhaseRule rule;
        RequestBlockingHandler requestBlockingHandler;
        Phase phase;
        this.configurationContext.setProperty("local_wso2wsas.block.requests", (Object)"true");
        AxisConfiguration axisConfig = this.configurationContext.getAxisConfiguration();
        Iterator iterator = axisConfig.getInFlowPhases().iterator();
        while (iterator.hasNext()) {
            phase = (Phase)iterator.next();
            if (!(phase instanceof DispatchPhase)) continue;
            requestBlockingHandler = new RequestBlockingHandler();
            if (phase.getHandlers().contains(requestBlockingHandler)) break;
            rule = new PhaseRule("Dispatch");
            rule.setAfter("SOAPMessageBodyBasedDispatcher");
            rule.setBefore("InstanceDispatcher");
            handlerDesc = requestBlockingHandler.getHandlerDesc();
            handlerDesc.setHandler((Handler)requestBlockingHandler);
            handlerDesc.setName("RequestBlockingHandler");
            handlerDesc.setRules(rule);
            phase.addHandler((Handler)requestBlockingHandler);
            break;
        }
        iterator = axisConfig.getInFaultFlowPhases().iterator();
        while (iterator.hasNext()) {
            phase = (Phase)iterator.next();
            if (!(phase instanceof DispatchPhase)) continue;
            requestBlockingHandler = new RequestBlockingHandler();
            if (phase.getHandlers().contains(requestBlockingHandler)) continue;
            rule = new PhaseRule("Dispatch");
            rule.setAfter("SOAPMessageBodyBasedDispatcher");
            rule.setBefore("InstanceDispatcher");
            handlerDesc = requestBlockingHandler.getHandlerDesc();
            handlerDesc.setHandler((Handler)requestBlockingHandler);
            handlerDesc.setName("RequestBlockingHandler");
            handlerDesc.setRules(rule);
            phase.addHandler((Handler)requestBlockingHandler);
            break;
        }
        ChannelSender sender = new ChannelSender();
        this.channelListener = new ChannelListener(this.configurationContext, this.configurationManager, this.contextManager, this.controlCmdProcessor, sender);
        this.controlCmdProcessor.setChannelSender(sender);
        this.channel = new GroupChannel();
        Parameter domainParam = this.getParameter("domain");
        byte[] domain = domainParam != null ? ((String)domainParam.getValue()).getBytes() : "apache.axis2.domain".getBytes();
        this.channel.getMembershipService().setDomain(domain);
        DomainFilterInterceptor dfi = new DomainFilterInterceptor();
        dfi.setDomain(domain);
        this.channel.addInterceptor((ChannelInterceptor)dfi);
        this.channel.addChannelListener((org.apache.catalina.tribes.ChannelListener)this.channelListener);
        TribesMembershipListener membershipListener = new TribesMembershipListener();
        this.channel.addMembershipListener((MembershipListener)membershipListener);
        try {
            this.channel.start(15);
            String localHost = TribesUtil.getLocalHost((Channel)this.channel);
            if (localHost.startsWith("127.0.")) {
                this.channel.stop(15);
                throw new ClusteringFault("Cannot join cluster using IP " + localHost + ". Please set an IP address other than " + localHost + " in your /etc/hosts file and retry.");
            }
        }
        catch (ChannelException e) {
            throw new ClusteringFault("Error starting Tribes channel", (Exception)((Object)e));
        }
        sender.setChannel((Channel)this.channel);
        Member[] members = this.channel.getMembers();
        log.info((Object)("Local Tribes Member " + TribesUtil.getLocalHost((Channel)this.channel)));
        TribesUtil.printMembers(members);
        if (this.configurationManager != null) {
            this.configurationManager.setSender(sender);
            this.getInitializationMessage(members, sender, new GetConfigurationCommand());
        }
        if (this.contextManager != null) {
            this.contextManager.setSender(sender);
            this.channelListener.setContextManager(this.contextManager);
            this.getInitializationMessage(members, sender, new GetStateCommand());
            ClusteringContextListener contextListener = new ClusteringContextListener(sender);
            this.configurationContext.addContextListener((ContextListener)contextListener);
        }
        this.configurationContext.setNonReplicableProperty("local_cluster.initialized", (Object)"true");
        this.configurationContext.removeProperty("local_wso2wsas.block.requests");
    }

    private void getInitializationMessage(Member[] members, ChannelSender sender, ClusteringCommand command) {
        Random random = new Random();
        ArrayList<String> sentMembersList = new ArrayList<String>();
        for (int numberOfTries = 0; members.length > 0 && this.configurationContext.getPropertyNonReplicable("local_cluster.initialized") == null && numberOfTries < 50; ++numberOfTries) {
            try {
                members = this.channel.getMembers();
                int memberIndex = random.nextInt(members.length);
                Member member = members[memberIndex];
                if (sentMembersList.contains(TribesUtil.getHost(member))) continue;
                long tts = sender.sendToMember(command, member);
                this.configurationContext.setNonReplicableProperty("local_cluster.time.to.send", (Object)new Long(tts));
                sentMembersList.add(TribesUtil.getHost(member));
                log.debug((Object)"WAITING FOR STATE INITIALIZATION MESSAGE...");
                Thread.sleep(tts + 5L);
                continue;
            }
            catch (Exception e) {
                log.error((Object)e);
                break;
            }
        }
    }

    public void setConfigurationManager(ConfigurationManager configurationManager) {
        this.configurationManager = (DefaultConfigurationManager)configurationManager;
    }

    public void setContextManager(ContextManager contextManager) {
        this.contextManager = (DefaultContextManager)contextManager;
    }

    public void addParameter(Parameter param) throws AxisFault {
        this.parameters.put(param.getName(), param);
    }

    public void deserializeParameters(OMElement parameterElement) throws AxisFault {
        throw new UnsupportedOperationException();
    }

    public Parameter getParameter(String name) {
        return (Parameter)this.parameters.get(name);
    }

    public ArrayList getParameters() {
        ArrayList list = new ArrayList();
        Iterator it = this.parameters.keySet().iterator();
        while (it.hasNext()) {
            list.add(this.parameters.get(it.next()));
        }
        return list;
    }

    public boolean isParameterLocked(String parameterName) {
        Parameter parameter = (Parameter)this.parameters.get(parameterName);
        if (parameter != null) {
            return parameter.isLocked();
        }
        return false;
    }

    public void removeParameter(Parameter param) throws AxisFault {
        this.parameters.remove(param.getName());
    }

    public void shutdown() throws ClusteringFault {
        log.debug((Object)"Enter: TribesClusterManager::shutdown");
        if (this.channel != null) {
            try {
                this.channel.stop(15);
            }
            catch (ChannelException e) {
                if (log.isDebugEnabled()) {
                    log.debug((Object)"Exit: TribesClusterManager::shutdown");
                }
                throw new ClusteringFault((Exception)((Object)e));
            }
        }
        log.debug((Object)"Exit: TribesClusterManager::shutdown");
    }

    public void setConfigurationContext(ConfigurationContext configurationContext) {
        this.configurationContext = configurationContext;
        this.controlCmdProcessor.setConfigurationContext(configurationContext);
        if (this.channelListener != null) {
            this.channelListener.setConfigurationContext(configurationContext);
        }
    }
}

