/*
 * Decompiled with CFR 0.152.
 */
package org.apache.axis2.clustering.context.commands;

import org.apache.axis2.clustering.ClusteringFault;
import org.apache.axis2.clustering.context.commands.UpdateContextCommand;
import org.apache.axis2.context.AbstractContext;
import org.apache.axis2.context.ConfigurationContext;
import org.apache.axis2.context.ServiceGroupContext;
import org.apache.axis2.description.AxisServiceGroup;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class UpdateServiceGroupContextCommand
extends UpdateContextCommand {
    private static Log log = LogFactory.getLog((Class)UpdateServiceGroupContextCommand.class);
    protected String serviceGroupName;
    protected String serviceGroupContextId;

    public String getServiceGroupName() {
        return this.serviceGroupName;
    }

    public void setServiceGroupName(String serviceGroupName) {
        this.serviceGroupName = serviceGroupName;
    }

    public String getServiceGroupContextId() {
        return this.serviceGroupContextId;
    }

    public void setServiceGroupContextId(String serviceGroupContextId) {
        this.serviceGroupContextId = serviceGroupContextId;
    }

    public void execute(ConfigurationContext configContext) throws ClusteringFault {
        ServiceGroupContext sgCtx = configContext.getServiceGroupContext(this.serviceGroupContextId);
        if (sgCtx == null) {
            AxisServiceGroup axisServiceGroup = configContext.getAxisConfiguration().getServiceGroup(this.serviceGroupName);
            if (axisServiceGroup == null) {
                return;
            }
            sgCtx = new ServiceGroupContext(configContext, axisServiceGroup);
            sgCtx.setId(this.serviceGroupContextId);
            configContext.addServiceGroupContextIntoSoapSessionTable(sgCtx);
        }
        log.debug((Object)("###### Gonna update SG prop in " + this.serviceGroupContextId + "===" + sgCtx));
        this.propertyUpdater.updateProperties((AbstractContext)sgCtx);
    }

    public String toString() {
        return "UpdateServiceGroupContextCommand(" + this.uniqueId + ")";
    }
}

