/*
 * Decompiled with CFR 0.152.
 */
package org.apache.axis2.clustering.context;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import org.apache.axiom.om.OMElement;
import org.apache.axis2.AxisFault;
import org.apache.axis2.clustering.ClusteringCommand;
import org.apache.axis2.clustering.ClusteringFault;
import org.apache.axis2.clustering.context.ContextClusteringCommand;
import org.apache.axis2.clustering.context.ContextClusteringCommandFactory;
import org.apache.axis2.clustering.context.ContextManager;
import org.apache.axis2.clustering.context.ContextManagerListener;
import org.apache.axis2.clustering.context.commands.ContextClusteringCommandCollection;
import org.apache.axis2.clustering.tribes.AckManager;
import org.apache.axis2.clustering.tribes.ChannelSender;
import org.apache.axis2.context.AbstractContext;
import org.apache.axis2.context.ConfigurationContext;
import org.apache.axis2.context.ServiceContext;
import org.apache.axis2.context.ServiceGroupContext;
import org.apache.axis2.description.Parameter;

public class DefaultContextManager
implements ContextManager {
    private ConfigurationContext configContext;
    private Map parameters = new HashMap();
    private ChannelSender sender;
    private ContextReplicationProcessor processor = new ContextReplicationProcessor();
    private Map excludedReplicationPatterns = new HashMap();

    public void setSender(ChannelSender sender) {
        this.sender = sender;
    }

    public String updateContext(AbstractContext context) throws ClusteringFault {
        ContextClusteringCommand cmd = ContextClusteringCommandFactory.getUpdateCommand(context, this.excludedReplicationPatterns, false);
        if (cmd != null) {
            this.processor.process(cmd);
            return cmd.getUniqueId();
        }
        return null;
    }

    public String updateContexts(AbstractContext[] contexts) throws ClusteringFault {
        ContextClusteringCommandCollection cmd = ContextClusteringCommandFactory.getCommandCollection(contexts, this.excludedReplicationPatterns);
        this.processor.process(cmd);
        return cmd.getUniqueId();
    }

    public String removeContext(AbstractContext context) throws ClusteringFault {
        ContextClusteringCommand cmd = ContextClusteringCommandFactory.getRemoveCommand(context);
        this.processor.process(cmd);
        return cmd.getUniqueId();
    }

    public boolean isContextClusterable(AbstractContext context) {
        return context instanceof ConfigurationContext || context instanceof ServiceContext || context instanceof ServiceGroupContext;
    }

    public boolean isMessageAcknowledged(String messageUniqueId) throws ClusteringFault {
        return AckManager.isMessageAcknowledged(messageUniqueId, this.sender);
    }

    public void process(ContextClusteringCommand command) throws ClusteringFault {
        command.execute(this.configContext);
    }

    public void setContextManagerListener(ContextManagerListener listener) {
        if (this.configContext != null) {
            listener.setConfigurationContext(this.configContext);
        }
    }

    public void setConfigurationContext(ConfigurationContext configurationContext) {
        this.configContext = configurationContext;
    }

    public void setReplicationExcludePatterns(String contextType, List patterns) {
        this.excludedReplicationPatterns.put(contextType, patterns);
    }

    public Map getReplicationExcludePatterns() {
        return this.excludedReplicationPatterns;
    }

    public void addParameter(Parameter param) throws AxisFault {
        this.parameters.put(param.getName(), param);
    }

    public void removeParameter(Parameter param) throws AxisFault {
        this.parameters.remove(param.getName());
    }

    public Parameter getParameter(String name) {
        return (Parameter)this.parameters.get(name);
    }

    public ArrayList getParameters() {
        ArrayList list = new ArrayList();
        Iterator iter = this.parameters.keySet().iterator();
        while (iter.hasNext()) {
            list.add(this.parameters.get(iter.next()));
        }
        return list;
    }

    public boolean isParameterLocked(String parameterName) {
        return this.getParameter(parameterName).isLocked();
    }

    public void deserializeParameters(OMElement parameterElement) throws AxisFault {
        throw new UnsupportedOperationException();
    }

    private class ContextReplicationProcessor {
        private ContextReplicationProcessor() {
        }

        public void process(final ContextClusteringCommand cmd) throws ClusteringFault {
            if (DefaultContextManager.this.sender == null) {
                Thread processorThread = new Thread("ProcessorThread"){

                    public void run() {
                        do {
                            try {
                                Thread.sleep(300L);
                            }
                            catch (InterruptedException e) {
                                e.printStackTrace();
                            }
                        } while (DefaultContextManager.this.sender == null);
                        try {
                            long tts = DefaultContextManager.this.sender.sendToGroup((ClusteringCommand)cmd);
                            DefaultContextManager.this.configContext.setNonReplicableProperty("local_cluster.time.to.send", (Object)new Long(tts));
                        }
                        catch (ClusteringFault clusteringFault) {
                            throw new RuntimeException(clusteringFault);
                        }
                    }
                };
                processorThread.start();
            } else {
                long tts = DefaultContextManager.this.sender.sendToGroup((ClusteringCommand)cmd);
                DefaultContextManager.this.configContext.setNonReplicableProperty("local_cluster.time.to.send", (Object)new Long(tts));
            }
        }
    }
}

