// VarArray.cpp : CVarArray ̎

#include "stdafx.h"
#include "VarArray.h"

#include <vector>

// CVarArray

HRESULT CVarArray::FinalConstruct()
{
	m_colSeparator = L" \t"; // +^u
	m_colSeparatorShortSpace = VARIANT_TRUE;
	m_colReturnNull = VARIANT_FALSE;

	return S_OK;
}

void CVarArray::FinalRelease()
{
	// Ver2A[X̃^C~OŃq[vkނB
	_heapmin();
}

STDMETHODIMP CVarArray::InterfaceSupportsErrorInfo(REFIID riid)
{
	// ISupportErrorInfo̎Ver2Œǉ܂B

	static const IID* arr[] = 
	{
		&IID_IVarArray
	};

	for (int i=0; i < sizeof(arr) / sizeof(arr[0]); i++)
	{
		if (InlineIsEqualGUID(*arr[i],riid))
			return S_OK;
	}
	return S_FALSE;
}

/**
 * W̗񋓎q
 * @param ppUnk 񋓎q
 * @return HRESULT
 */
HRESULT CVarArray::get__NewEnum(IUnknown **ppUnk)
{
	// 񋓎q̎Ver2Œǉ܂B

	class EnumObj
		: public CComObjectRootEx<CComSingleThreadModel>
		, public IEnumVARIANT
	{
	public:
		DECLARE_PROTECT_FINAL_CONSTRUCT()

		BEGIN_COM_MAP(EnumObj)
		   COM_INTERFACE_ENTRY(IEnumVARIANT)
		END_COM_MAP()

		CComPtr<IVarArray> m_pArray;

		LONG m_idx;

		HRESULT FinalConstruct()
		{
			m_pArray = NULL;
			m_idx = 0;
			return S_OK;
		}

		void FinalRelease()
		{
			m_pArray.Release();

			// [X̃^C~OŃq[vkނ
			_heapmin();
		}

        virtual /* [local] */ HRESULT STDMETHODCALLTYPE Next( 
            /* [in] */ ULONG celt,
            /* [length_is][size_is][out] */ VARIANT *rgVar,
            /* [out] */ ULONG *pCeltFetched)
		{
			ATLASSERT(m_pArray);

			// 
			if (pCeltFetched) {
				*pCeltFetched = 0;
			}

			if (!rgVar) {
				return E_INVALIDARG;
			}

			for (ULONG idx = 0; idx < celt; idx++) {
				VariantInit(&rgVar[idx]);
			}
			try {
				// Rs[
				ULONG copied = 0;

				LONG count = 0;
				HRESULT hr;
				if (FAILED(hr = m_pArray->get_Count(&count))) {
					AtlThrow(hr);
				}
				while ((copied + m_idx) < static_cast<ULONG>(count) && copied < celt) {
					if (FAILED(hr = m_pArray->get_Value(copied + m_idx, &rgVar[copied]))) {
						AtlThrow(hr);
					}
					copied++;
				}
				m_idx += copied;

				// ʂԂ
				if (pCeltFetched) {
					*pCeltFetched = copied;
				}

				return celt == copied ? S_OK : S_FALSE;
			
			} catch (CAtlException &ex) {
				// G[Ari[ς݃f[^̃NA				
				for (ULONG idx = 0; idx < celt; idx++) {
					VariantClear(&rgVar[idx]);
				}

				return ex.m_hr;
			}
		}
        
        virtual HRESULT STDMETHODCALLTYPE Skip( 
            /* [in] */ ULONG celt)
		{
			ATLASSERT(m_pArray);

			LONG count = 0;
			HRESULT hr;
			if (FAILED(hr = m_pArray->get_Count(&count))) {
				return hr;
			}

			if (m_idx + celt >= static_cast<ULONG>(count)) {
				// I[o[
				m_idx = count;
				return S_FALSE;
			}

			m_idx += celt;

			return S_OK;
		}
        
        virtual HRESULT STDMETHODCALLTYPE Reset( void) 
		{
			ATLASSERT(m_pArray);

			m_idx = 0;
			return S_OK;
		}
        
        virtual HRESULT STDMETHODCALLTYPE Clone( 
            /* [out] */ IEnumVARIANT **ppEnum)
		{
			ATLASSERT(m_pArray);

			CComPtr<IUnknown> pUnk(NULL);
			HRESULT hr = CreateEnumObj(m_pArray, m_idx, &pUnk);
			if (FAILED(hr)) {
				return hr;
			}
			return pUnk->QueryInterface(ppEnum);
		}

		static HRESULT CreateEnumObj(IVarArray *pArray, LONG idx, IUnknown **ppUnk)
		{
			if (!ppUnk) {
				return E_POINTER;
			}
			if (!pArray) {
				return E_INVALIDARG;
			}

			CComObject<EnumObj> *pEnumObj = NULL;
			HRESULT hr;
			if (FAILED(hr = CComObject<EnumObj>::CreateInstance(&pEnumObj))) {
				return hr;
			}
			CComPtr<IEnumVARIANT> pEnumVariant(pEnumObj);

			pEnumObj->m_idx = idx;
			
			pEnumObj->m_pArray = pArray;

			return pEnumVariant->QueryInterface(ppUnk);
		}
	};

	return EnumObj::CreateEnumObj(this, 0, ppUnk);
}

/**
 * ftHg̃ANZbTB
 * ValuevpeBƓB
 * @param idx sԍ(0x[X)
 * @param pValue s̓e
 * @return HRESULT
 */
HRESULT CVarArray::get__Value(long idx, VARIANT *pValue)
{
	return get_Value(idx, pValue);
}

/**
 * ftHg̃ANZbTB
 * ValuevpeBƓB
 * @param idx sԍ(0x[X)
 * @param newValue s̓e
 * @return HRESULT
 */
HRESULT CVarArray::put__Value(long idx, VARIANT newValue)
{
	return put_Value(idx, newValue);
}

/**
 * gpłB
 * @param pValue gp
 * @return HRESULT
 */
HRESULT CVarArray::get_ColReturnNull(VARIANT_BOOL *pValue)
{
	if (!pValue) {
		return E_POINTER;
	}

	// *NOTE* ƂƁÃvpeB͂ǂɂgĂ炸AwvɂLڂ܂B

	*pValue = m_colReturnNull;

	return S_OK;
}

/**
 * gpłB
 * @param newValue gp
 * @return HRESULT
 */
HRESULT CVarArray::put_ColReturnNull(VARIANT_BOOL newValue)
{
	// *NOTE* ƂƁÃvpeB͂ǂɂgĂ炸AwvɂLڂ܂B

	m_colReturnNull = newValue;

	return S_OK;
}

/**
 * 񑀍삷Ƃ̋؂蕶擾B
 * @param pValue ؂蕶i[
 * @return HRESULT
 */
HRESULT CVarArray::get_ColSeparateChar(BSTR *pValue)
{
	if (!pValue) {
		return E_POINTER;
	}

	CComBSTR value(m_colSeparator);
	*pValue = value.Detach();

	return S_OK;
}

/**
 * 񑀍삷Ƃ̋؂蕶ݒ肷B
 * ؂蕶̓TQ[gyA̓T|[gĂ炸Aw肵ꍇ
 * ݂̎ł̓G[ƂȂ܂B
 * @param newValue ؂蕶
 * @return HRESULT
 */
HRESULT CVarArray::put_ColSeparateChar(BSTR newValue)
{
	if (newValue) {

		// TQ[gyA܂܂邩`FbN
		LPCWSTR p = newValue;
		while (*p) {
			WCHAR ch = *p++;
			if (IS_HIGH_SURROGATE(ch)) {
				// TQ[gyA̓T|[gȂ
				return Error(IDS_UNSUPPORTED_SEPARATE_CHAR);
			}
		}

		m_colSeparator = newValue;
	} else {
		m_colSeparator = L"";
	}

	return S_OK;
}

/**
 * ؂蕶ɑ󔒂XLbv邩tO擾B
 * @param pValue tOԂ
 * @return HRESULT
 */
HRESULT CVarArray::get_ColSeparateShortSpace(VARIANT_BOOL *pValue)
{
	if (!pValue) {
		return E_POINTER;
	}

	*pValue = m_colSeparatorShortSpace;

	return S_OK;
}

/**
 * ؂蕶ɑ󔒂XLbv邩tOݒ肷B
 * @param newValue XLbv邩?
 * @return HRESULT
 */
HRESULT CVarArray::put_ColSeparateShortSpace(VARIANT_BOOL newValue)
{
	m_colSeparatorShortSpace = newValue;

	return S_OK;
}

/**
 * sԂ
 * @return pCount sԂ
 * @return HRESULT
 */
HRESULT CVarArray::get_Count(LONG *pCount)
{
	if (!pCount) {
		return E_POINTER;
	}

	*pCount = static_cast<LONG>(m_array.GetCount());

	return S_OK;
}

/**
 * ̓e擾B
 * s݂ȂꍇNULLԂB
 * @param pValue ̓ei[ANULL
 * @return HRESULT
 */
HRESULT CVarArray::get_LastValue(VARIANT *pValue)
{
	if (!pValue) {
		return E_POINTER;
	}
	VariantInit(pValue);

	size_t idx = m_array.GetCount();
	if (idx == 0) {
		pValue->vt = VT_NULL;
		return S_FALSE;
	}

	CComBSTR value;
	value = m_array.GetAt(idx - 1);

	pValue->vt = VT_BSTR;
	pValue->bstrVal = value.Detach();
	return S_OK;
}

/**
 * ̍sύXB
 * 1s݂Ȃꍇ͐V1s쐬B
 * @param newValue e
 * @return HRESULT
 */
HRESULT CVarArray::put_LastValue(VARIANT newValue)
{
	size_t count = m_array.GetCount();
	LONG idx;
	if (count == 0) {
		idx = 0;
	} else {
		idx = static_cast<LONG>(count) - 1;
	}
	return put_Value(idx, newValue);
}

/**
 * 擪ɍsǉB
 * @param mes e
 * @param pIndex 0Ԃ
 * @return HRESULT
 */
HRESULT CVarArray::AddHead(BSTR mes, LONG *pIndex)
{
	if (!pIndex) {
		return E_POINTER;
	}

	if (mes) {
		m_array.InsertAt(0, mes);
	} else {
		m_array.InsertAt(0, L"");
	}

	return S_OK;
}

/**
 * ɍsǉB
 * @param mes e
 * @param pIndex 0Ԃ
 * @return HRESULT
 */
HRESULT CVarArray::AddTail(BSTR mes, LONG *pIndex)
{
	if (!pIndex) {
		return E_POINTER;
	}

	if (mes) {
		m_array.Add(mes);
	} else {
		m_array.Add(L"");
	}

	*pIndex = 0; // ݊̂

	return S_OK;
}

/**
 * w肵sԍɐVs}B
 * @param idx sԍ(0x[X)
 * @param mes e
 * @param pIndex 0Ԃ
 * @return HRESULT
 */
HRESULT CVarArray::Insert(LONG idx, BSTR mes, LONG *pIndex)
{
	if (idx < 0) {
		return E_INVALIDARG;
	}
	if (!pIndex) {
		return E_POINTER;
	}

	if (mes) {
		m_array.InsertAt(idx, mes);
	} else {
		m_array.InsertAt(idx, L"");
	}

	*pIndex = 0; // ݊̂

	return S_OK;
}

/**
 * 擪폜B
 * łɋłꍇ͉ȂB
 * @param s̍sԂB
 * @return HRESULT
 */
HRESULT CVarArray::RemoveHead(LONG *pIndex)
{
	if (!pIndex) {
		return E_POINTER;
	}

	size_t count = m_array.GetCount();
	if (count > 0) {
		m_array.RemoveAt(0);
		count--;
	}

	*pIndex = static_cast<LONG>(count);

	return S_OK;
}

/**
 * 폜B
 * łɋłꍇ͉ȂB
 * @param pIndex s̍sԂ
 * @return HRESULT
 */
HRESULT CVarArray::RemoveTail(LONG *pIndex)
{
	if (!pIndex) {
		return E_POINTER;
	}

	size_t count = m_array.GetCount();
	if (count > 0) {
		m_array.RemoveAt(count - 1);
		count--;
	}

	*pIndex = static_cast<LONG>(count);

	return S_OK;
}

/**
 * w肵s폜܂B
 * 폜ꂽs͐؂l߂܂B
 * sԍ̒lł邩A̍s͈̔͊Ołꍇ
 * ܂B
 * @param idx sԍ
 * @param pIndex s̍sԂ
 * @return HRESULT
 */
HRESULT CVarArray::Remove(LONG idx, LONG *pIndex)
{
	if (!pIndex) {
		return E_POINTER;
	}

	HRESULT hr = S_FALSE;

	LONG count = static_cast<LONG>(m_array.GetCount());
	if (count > 0 && idx >= 0 && idx < count) {
		m_array.RemoveAt(idx);
		count--;
		hr = S_OK;
	}

	*pIndex = static_cast<LONG>(count);

	return hr;
}

/**
 * ׂĂ̓eNA܂B
 */
HRESULT CVarArray::RemoveAll()
{
	m_array.RemoveAll();

	// Ver2Aq[vkނB
	_heapmin();

	return S_OK;
}

HRESULT CVarArray::ChangeTerminateChar(LONG nStartIdx, LONG nEndIdx, BSTR newSeparateChar, VARIANT bChangeSeparateChar, VARIANT_BOOL *pResult)
{
	if (!pResult) {
		return E_POINTER;
	}

	if (nStartIdx < 0) {
		nStartIdx = 0;
	}

	LONG count = static_cast<LONG>(m_array.GetCount());

	if (count == 0) {
		// Ȃ΂ȂɂȂ
		*pResult = VARIANT_TRUE;
		return S_FALSE;
	}

	if (nEndIdx < 0 || nEndIdx >= count) {
		nEndIdx = static_cast<LONG>(count) - 1;
	}

	// ͈͂t
	if (nEndIdx < nStartIdx) {
		*pResult = VARIANT_FALSE;
		return S_OK;
	}

	const size_t newSeparateCharLen = SysStringLen(newSeparateChar);

	for (LONG idx = nStartIdx; idx <= nEndIdx; idx++) {
		// s̎擾
		CAtlStringW line = m_array.GetAt(idx);
		const size_t lineLen = line.GetLength();

		// 񐔂̎擾
		SHORT colCount = 0;
		if (FAILED(get_ColCount(idx, &colCount))) {
			// \ʃG[
			ATLASSERT(false);
			return E_FAIL;
		}

		// ҏWobt@ (TCÝAs̒ +  x V؂ + I[)
		size_t bufsiz = lineLen + newSeparateCharLen * colCount + 1; // I[
		std::vector<WCHAR> lineBuf(bufsiz);
		LPWSTR pBuf = &lineBuf[0];

		// ̍č\z
		int colidx = 0;
		LPCWSTR p = line;
		do {
			if (colidx > 0 && newSeparateCharLen > 0) {
				memcpy(pBuf, newSeparateChar, sizeof(WCHAR) * newSeparateCharLen);
				pBuf += newSeparateCharLen;
				bufsiz -= newSeparateCharLen;
			}

			p = GetNextColumn(p, pBuf, bufsiz);
			
			size_t colLen = wcslen(pBuf);
			pBuf += colLen;
			bufsiz -= colLen;

			colidx++;
		} while (p);

		*pBuf = 0;

		// ҏWʂi[
		m_array.SetAt(idx, &lineBuf[0]);
	}

	// ؂蕶̕ύXL
	if (!IsNullOrError(&bChangeSeparateChar)) {
		VARIANT tmp;
		VariantInit(&tmp);
		if (SUCCEEDED(VariantChangeType(&tmp, &bChangeSeparateChar, VARIANT_NOUSEROVERRIDE, VT_BOOL))) {
			ATLASSERT(tmp.vt == VT_BOOL);
			if (tmp.boolVal) {
				HRESULT hr;
				if (FAILED(hr = put_ColSeparateChar(newSeparateChar))) {
					// ؂蕶̐ݒɎs
					return hr;
				}
			}
		}
	}

	*pResult = VARIANT_TRUE;
	return S_OK;
}

/**
 * w肵s͈͂̒ɂ镶̌sB
 * ꍇ͍sԍԂB
 * 擪猟čŏɌ̂B
 * ݂Ȃꍇ-1ԂB
 * @param nStartIdx Jns(0x[X)A̒lw肷0Ƃ݂ȂB
 * @param nEndIdx Is(0x[X)A̒lw肷邩ős𒴂Ăꍇ͖܂łƂ݂ȂB
 * @param strMatch 镶
 * @param nType [hA0:vA1:OvA2:SvB
 * @param pIndex ꂽŏ̍sԍA-1i[|C^
 * @return HRESULT
 */
HRESULT CVarArray::Find(LONG nStartIdx, LONG nEndIdx, BSTR strMatch, VARIANT nType, LONG *pIndex)
{
	return FindCol(nStartIdx, nEndIdx, -1, strMatch, nType, pIndex);
}

/**
 * w肵s͈͂̒ɂAw̌̕sB
 * ꍇ͍sԍԂB
 * 擪猟čŏɌ̂B
 * ݂Ȃꍇ-1ԂB
 * @param nStartIdx Jns(0x[X)A̒lw肷0Ƃ݂ȂB
 * @param nEndIdx Is(0x[X)A̒lw肷邩ős𒴂Ăꍇ͖܂łƂ݂ȂB
 * @param nCol ԍ(0x[X)A̒lw肵ꍇ͗ł͂ȂsPʂł̌
 * @param strMatch 镶
 * @param nType [hA0:vA1:OvA2:SvB
 * @param pIndex ꂽŏ̍sԍA-1i[|C^
 * @return HRESULT
 */
HRESULT CVarArray::FindCol(LONG nStartIdx, LONG nEndIdx, SHORT nCol, BSTR strMatch, VARIANT nType, LONG *pIndex)
{
	if (!pIndex) {
		return E_POINTER;
	}

	LONG count = static_cast<LONG>(m_array.GetCount());
	if (count == 0) {
		// Ȃ̂ŏɔꂸB
		*pIndex = -1;
		return S_FALSE;
	}

	if (nStartIdx < 0) {
		nStartIdx = 0;
	}

	if (nEndIdx < 0 || nEndIdx >= count) {
		nEndIdx = count - 1;
	}

	if (nStartIdx > nEndIdx) {
		// ͈͂t̏ꍇ͏ɔꂸB
		*pIndex = -1;
		return S_FALSE;
	}

	if (SysStringLen(strMatch) == 0) {
		// NULL܂͋̏ꍇ͏ɔꂸB
		*pIndex = -1;
		return S_FALSE;
	}

	// [h̎擾
	int nSearchMode = 0;
	if (!IsNullOrError(&nType)) {
		VARIANT tmp;
		VariantInit(&tmp);
		if (SUCCEEDED(VariantChangeType(&tmp, &nType, VARIANT_NOUSEROVERRIDE, VT_I2))) {
			ATLASSERT(tmp.vt == VT_I2);
			nSearchMode = tmp.iVal;
		}
	}

	for (LONG idx = nStartIdx; idx <= nEndIdx; idx++) {
		// s̎擾
		CAtlStringW line = m_array.GetAt(idx);
		CAtlStringW value;

		if (nCol >= 0) {
			// P
			size_t bufsiz = line.GetLength();
			std::vector<WCHAR> buf(bufsiz + 1);

			LPCWSTR p = line;
			int colidx = 0;
			do {
				if (colidx == nCol) {
					p = GetNextColumn(p, &buf[0], bufsiz);
					break;
				} else {
					p = GetNextColumn(p, NULL, 0);
				}
			} while (p);

			value = &buf[0];

		} else {
			// 1sP
			value = line;
		}

		bool bMatched = false;

		switch (nSearchMode) {
			case SEARCHMODE_PREFIX:
				// 擪Ƀ}b`
				bMatched = (value.Find(strMatch) == 0);
				break;

			case SEARCHMODE_FULL:
				// SɃ}b`
				bMatched = (value == strMatch);
				break;

			default:
			case SEARCHMODE_PART:
				// ǂɃ}b`
				bMatched = (value.Find(strMatch) >= 0);
				break;
		}

		if (bMatched) {
			*pIndex = idx;
			return S_OK;
		}
	}

	*pIndex = -1;
	return S_FALSE;
}

/**
 * w肵s̓e擾܂B
 * s̒lł邩A̍s͈̔͂𒴂ĂꍇNULLԂ܂B
 * @param idx sԍ(0x[X)
 * @param pValue s̓ei[
 * @return HRESULT
 */
HRESULT CVarArray::get_Value(LONG idx, VARIANT *pValue)
{
	if (!pValue) {
		return E_POINTER;
	}
	VariantInit(pValue);
	pValue->vt = VT_NULL;

	LONG count = static_cast<LONG>(m_array.GetCount());
	if (count > 0 && idx >= 0 && idx < count) {
		CComBSTR value;
		value = m_array.GetAt(idx);
		pValue->vt = VT_BSTR;
		pValue->bstrVal = value.Detach();
		return S_OK;
	}

	return S_FALSE;
}

/**
 * w肵s̓eݒ肵܂B
 * sԍ̒lłΉ܂B
 * sԍ̍s𒴂Ăꍇ͊g܂B
 * @param idx sԍ(0x[X)
 * @param newValue s̓e
 @ @return HRESULT
 */
HRESULT CVarArray::put_Value(LONG idx, VARIANT newValue)
{
	CComBSTR value;
	if (!IsNullOrError(&newValue)) {
		VARIANT tmp;
		VariantInit(&tmp);
		if (SUCCEEDED(VariantChangeType(&tmp, &newValue, VARIANT_NOUSEROVERRIDE, VT_BSTR))) {
			ATLASSERT(tmp.vt == VT_BSTR);
			value.Attach(tmp.bstrVal);
		}
	}
	if (idx < 0) {
		// G[ɂ͂Ȃ
		return S_FALSE;
	}

	if (value.Length() > 0) {
		m_array.SetAtGrow(idx, value);
	} else {
		m_array.SetAtGrow(idx, L"");
	}

	return S_OK;
}

/**
 * w肵s̗񐔂擾܂B
 * s̒lł邩As͈̔͂𒴂ĂꍇA
 * ؂肪w肳ĂȂꍇ͏0Ԃ܂B
 * łȂΗ̐Ԃ܂B(݂s͏1ȏƂȂ܂B)
 * @param idx sԍ(0x[X)
 * @param pCount 񐔂i[|C^
 * @return HRESULT
 */
HRESULT CVarArray::get_ColCount(LONG idx, SHORT *pCount)
{
	if (!pCount) {
		return E_POINTER;
	}
	
	LONG count = static_cast<LONG>(m_array.GetCount());

	if (idx < 0 || idx >= count || m_colSeparator.IsEmpty()) {
		// CfbNX͈͊Oł邩AJ؂蕶`ĂȂꍇ
		// J0ƂB
		*pCount = 0;
		return S_FALSE;
	}

	CAtlStringW line = m_array.GetAt(idx);
	LPCWSTR p = line;

	int colCount = 0;
	do {
		p = GetNextColumn(p, NULL, 0);
		colCount++;
	} while (p);

	*pCount = colCount;

	return S_OK;
}

/**
 * w肵śAw肵̒l擾܂B
 * sԍ܂͗ԍ̒lł邩As܂͈͗̔͂𒴂ĂꍇA
 * 󕶎Ԃ܂B
 * łȂΗ̕񂪕Ԃ܂B
 * @param idx sԍ(0x[X)
 * @param colidx ԍ(0x[X)
 * @param pColValue ̓ei[BSTRւ̃|C^
 */
HRESULT CVarArray::get_ColValue(LONG idx, SHORT colidx, BSTR *pColValue)
{
	if (!pColValue) {
		return E_POINTER;
	}

	LONG count = static_cast<LONG>(m_array.GetCount());

	if (idx >= 0 && idx < count && !m_colSeparator.IsEmpty() && colidx >= 0) {
		CAtlStringW line = m_array.GetAt(idx);

		LPCWSTR p = line;

		int colCount = 0;
		do {
			if (colCount == colidx) {
				// ̕擾
				int bufsiz = line.GetLength() + 1;
				std::vector<WCHAR> colBuf(bufsiz);

				p = GetNextColumn(p, &colBuf[0], bufsiz);

				*pColValue = SysAllocString(&colBuf[0]);
				return S_OK;
			}

			p = GetNextColumn(p, NULL, 0);
			colCount++;
		} while (p);
	}

	*pColValue = SysAllocString(L"");
	return S_FALSE;
}

/** 
 * w肵śAw肵̒lݒ肵܂B
 * sԍAԍƂɕ̒lw肵ꍇ͉܂B
 * sԍ͈̔͂𒴂Ăꍇ͊g܂B
 * ̏ꍇA̍s͋󕶎łƌȂė̐ݒ肪s܂B
 * ԍ͈̔͂𒴂Ăꍇ͗؂ƂāA؂蕶
 * ŏ̕؂蕶ƂĎgpė񂪍쐬܂B
 * ̑}܂͒uɔÁ̕A؂蕶
 * ŏ̕؂蕶Ƃčč\܂B
 * @param idx [in] sԍ(0x[X)
 * @param colidx [in] ԍ(0x[X)
 * @param newValue [in] u̓e
 * @return HRESULT
 */
HRESULT CVarArray::put_ColValue(LONG idx, SHORT colidx, BSTR newValue)
{
	if (idx < 0 || m_colSeparator.IsEmpty() || colidx < 0) {
		// ͈͊O
		return S_FALSE;
	}

	// ŏ̋؂蕶̗p (TQ[gyAlȂ)
	WCHAR separateChar = m_colSeparator.GetAt(0);

	// s擾
	CAtlStringW line;
	LONG count = static_cast<LONG>(m_array.GetCount());
	if (idx < count) {
		line = m_array.GetAt(idx);
	} else {
		line = L"";
	}

	const int lineLen = line.GetLength();
	const int newValueLen = SysStringLen(newValue);

	// sҏWpobt@
	// őŁAs̒(S+؂蕶) + u̒ + ؂蕶 + I[
	size_t bufsiz = lineLen + newValueLen + colidx + 1;
	std::vector<WCHAR> editBuf(bufsiz);
	LPWSTR pBuf = &editBuf[0];

	// ̗̎擾Ɨ̒uE͍č\z
	int colCount = 0;
	LPCWSTR p = line;
	do {
		if (colCount > 0) {
			// 2ڈȍ~ł΋؂蕶ŋ؂
			*pBuf++ = separateChar;
			bufsiz--;
		}

		if (colCount == colidx) {
			// w肵͓ǂݔ΂
			p = GetNextColumn(p, NULL, 0);

			// w肵VŒu
			if (newValue) {
				memcpy(pBuf, newValue, sizeof(WCHAR) * newValueLen);
				pBuf += newValueLen;
				bufsiz -= newValueLen;
			}

		} else {
			// w肵ȊÓÂ܂܃Rs[
			p = GetNextColumn(p, pBuf, bufsiz);

			size_t collen = wcslen(pBuf);
			pBuf += collen;
			bufsiz -= collen;
		}

		colCount++;
	} while (p);
	
	// ̗̏ꍇȂ}sB
	if (colCount <= colidx) {
		for (int colspan = colCount; colspan <= colidx; colspan++) {
			*pBuf++ = separateChar;
			bufsiz--;
		}
		if (newValue) {
			memcpy(pBuf, newValue, sizeof(WCHAR) * newValueLen);
			pBuf += newValueLen;
			bufsiz -= newValueLen;
		}
	}

	// I[
	*pBuf = 0;

	// s̒u
	m_array.SetAtGrow(idx, &editBuf[0]);

	return S_OK;
}

/**
 * ؂蕶܂͏I[ɏo܂ł̕擾A
 * ߂lƂċ؂蕶̎̃|C^ԂB
 * I[ɒBꍇNULLԂB
 * NULLnꍇ͕͊i[NULLԂB
 * 󕶎nꍇ͕͋󕶎ƂȂNULLԂB
 * Ɋi[obt@TCY͏I[0܂߂傫KvB
 * sꍇ͕0I[łTCY܂Ő؂l߂܂B
 * obt@TCY0̏ꍇ͉܂܂B
 * (1̏ꍇ͕KRIɏɏI[܂܂B)
 * @param p ͂镶ւ̃|C^ANULL̏ꍇ͉NULLԂB
 * @param colBuf ̊i[ANULL̏ꍇ͊i[B
 * @param bufsiz colBuf̃obt@TCYBI[0܂߂TCYKvB
 * @param ̃J̐擪A͖
 */
LPCWSTR CVarArray::GetNextColumn(LPCWSTR p, LPWSTR colBuf, size_t bufsiz)
{
	if (!p) {
		// NULL̏ꍇ
		return NULL;
	}

	LPCWSTR pSt = p;

	if (m_colSeparator.IsEmpty()) {
		// J؂蕶̏ꍇ͖[(\0)܂ŃXLbvB
		while (*p) p++;

	} else {
		// J؂蕶ɈʒuÂB
		// J؂蕶Ȃꍇ͖[(\0)܂ŃXLbvB
		size_t idx = wcscspn(p, m_colSeparator);
		p = p + idx;
	}

	// Jobt@̎w肪΃Rs[
	if (colBuf && bufsiz > 0) {
		size_t len = p - pSt;
		if (len > bufsiz - 1) {
			// obt@TCYI[0܂ŃJi[TCYɑȂ
			len = bufsiz - 1;
		}
		if (len > 0) {
			memcpy(colBuf, pSt, sizeof(WCHAR) * len);
		}
		colBuf[len] = 0;
	}

	// ؂蕶̎ɐi߂
	if (*p) {
		p++;
	}

	// A󔒂𖳎ꍇA|C^i߂
	if (m_colSeparatorShortSpace) {
		while (*p == ' ') p++;
	}

	if (*p) {
		// ܂ꍇ
		return p;
	}
	// Ȃꍇ
	return NULL;
}
