#!/usr/bin/env python
# -*- coding: utf-8 -*-

""" scionwelcome.py: Welcome screen for Scion """

__author__ = "Dorian"
__version__ = "0.16"
__maintainer__ = "Dorian"
__email__ = "doriang2015@outlook.com"

import gi
gi.require_version('Gtk', '3.0')
from gi.repository import Gtk
import os
#import subprocess
import sys

useub = False

class welcome(object):
    def __init__(self):
        global useub
        self.builder = Gtk.Builder()
        self.builder.add_from_file(os.path.split(os.path.abspath(__file__))[0] + "/scionwelcome.glade")
        self.builder.connect_signals(self)
        self.builder.get_object("winMain").set_title("Welcome")
        if os.path.isfile('/media/cdrom/cdrom/casper/vmlinuz'):
            self.builder.get_object("bt_Install").show()
        if os.path.isfile(os.path.expanduser('~/.config/autostart/scionwelcome.desktop')):
            self.builder.get_object("chk_Show").set_active(True)
        with open("/etc/os-release") as fil:
            for line in fil:
                try:
                    conf, v = line.rstrip().split("=")
                except:
                    print "Version parsing error"
                
                if conf == "VERSION_ID":
                    ver = v.strip('"')
        if "18.2" in ver:
            useub = True
        else:
            useub = False
        
    def run(self):
        self.builder.get_object("winMain").show()
        print "Run"

    def on_winMain_destroy(self, *args):
        print "Exit Welcome"
        Gtk.main_quit()

    def on_bt_Install_clicked(self, *args):
        if useub == True:
            os.system("sudo sh -c 'ubiquity gtk_ui' &")
        else:
            os.system('calamares &')
  
    def on_bt_Website_clicked(self, *args):
        os.system('x-www-browser https://osdn.net/projects/scionlinux/ &')
    
    def on_bt_Forum_clicked(self, *args):
        os.system('x-www-browser https://osdn.net/projects/scionlinux/forums/ &')
        
    def on_bt_Wiki_clicked(self, *args):
        os.system('x-www-browser https://osdn.net/projects/scionlinux/wiki/FrontPage &')        

    def on_bt_Changelog_clicked(self, *args):
        os.system('x-www-browser https://osdn.net/projects/scionlinux/wiki/ChangeLogVenus &')        

    def on_chk_Show_toggled(self, *args):
        if self.builder.get_object("chk_Show").get_active():
            os.system('cp /opt/scion/store/scionwelcome.desktop ~/.config/autostart/ &')
        else:
            os.system('rm ~/.config/autostart/scionwelcome.desktop &')

welcome().run()

if __name__ == '__main__':
    Gtk.main()




