//	Roast+ License v0.1

//	SIMD

#ifndef __SFJP_OPENMGL_roast_simd_float_xmm_register_HPP__
#define __SFJP_OPENMGL_roast_simd_float_xmm_register_HPP__


namespace roast
{
	namespace simd 
	{

		/** float̃ev[gꉻ ********************************************/

		template <int _PERMIT_SIMD>
		class xmm_register<float,_PERMIT_SIMD> : public ::roast::simd::simd_types
		{
		private:
			int _SIMD_TYPE;
			typedef xmm_register<float,_PERMIT_SIMD> FLOAT_xmm_register;
			typedef xmm_register<int,_PERMIT_SIMD> INT_xmm_register;
		protected:
			__m128 m_m128;
		public:
			//	RXgN^EfXgN^
			xmm_register() : _SIMD_TYPE(_PERMIT_SIMD) {}
			xmm_register( const FLOAT_xmm_register& reg ) : _SIMD_TYPE(_PERMIT_SIMD) {
				set(reg);
				//m_m128 = reg.m_m128;
			}
			xmm_register( const INT_xmm_register& reg ) : _SIMD_TYPE(_PERMIT_SIMD) {
				set(reg);
				//m_m128 = reg.m_m128;
			}
			xmm_register( float f ) : _SIMD_TYPE(_PERMIT_SIMD) {
				set(f);
			}
			xmm_register( __m128 m ) : _SIMD_TYPE(_PERMIT_SIMD) {
				m_m128 = m;
			}
			virtual ~xmm_register(){}

			///////////////////////////////////////////

			//	ݒƎ擾

			void zero(){
				m_m128 = _mm_setzero_ps();
			}

			void set (const float f){
				m_m128 = _mm_load_ps1(&f);
			}

			void set (__m128 m){
				m_m128 = m;
			}

			void set ( const FLOAT_xmm_register& param_reg ){
				m_m128 = param_reg.m_m128;
			}

			void set ( const INT_xmm_register &param_reg ){	//	from INT_xmm_register
				m_m128 = _mm_cvtepi32_ps(param_reg.get_m128i());
			}

			xmm_register& operator = (__m128 m){
				set(m);
				return *this;
			}

			xmm_register& operator = (const FLOAT_xmm_register &param_reg){
				set(param_reg);
				return *this;
			}

			xmm_register& operator = (const INT_xmm_register &param_reg){	//	from INT_xmm_register
				set(param_reg);
				return *this;
			}

			__m128 get_m128 () const {
				return m_m128;
			}

			INT_xmm_register to_ints (){
				return INT_xmm_register(*this);
			}

			operator __m128 () const {
				return m_m128;
			}

			operator INT_xmm_register (){
				return to_ints();
			}

			//	[]Iy[^

			float& operator[] (int i)
			{
				return m_m128.m128_f32[ i ];
			}

			////////////////////////////////////////////////////////

			//	lZ

			xmm_register operator + (const xmm_register &param_reg){
				xmm_register r;
				r.m_m128 = _mm_add_ps(m_m128, param_reg.m_m128);
				return r;
			}

			xmm_register& operator += (const xmm_register &param_reg){
				m_m128 = _mm_add_ps(m_m128, param_reg.m_m128);
				return *this;
			}

			xmm_register operator - (const xmm_register &param_reg){
				xmm_register r;
				r.m_m128 = _mm_sub_ps(m_m128, param_reg.m_m128);
				return r;
			}

			xmm_register& operator -= (const xmm_register &param_reg){
				m_m128 = _mm_sub_ps(m_m128, param_reg.m_m128);
				return *this;
			}

			xmm_register operator * (const xmm_register &param_reg){
				/*xmm_register r;
				r.m_m128 = _mm_mul_ps(m_m128, param_reg.m_m128);
				return r;*/
				//return xmm_register( _mm_mul_ps(m_m128, param_reg.m_m128) );
				xmm_register r(m_m128);
				r *= param_reg;
				return r;
			}

			xmm_register& operator *= (const xmm_register &param_reg){
				m_m128 = _mm_mul_ps(m_m128, param_reg.m_m128);
				return *this;
			}

			xmm_register operator / (const xmm_register &param_reg){
				xmm_register r;
				r.m_m128 = _mm_div_ps(m_m128, param_reg.m_m128);
				return r;
			}

			xmm_register& operator /= (const xmm_register &param_reg){
				m_m128 = _mm_div_ps(m_m128, param_reg.m_m128);
				return *this;
			}

			////////////////////////////////////////////////////////

			//	rZ

			bool operator == (const xmm_register &param_reg)
			{
				//if ( _PERMIT_SIMD >= ROAST_SIMD_TYPE_SSE4 )
				//	return _mm_testz_si128(m_m128, param_reg.m_m128) != 0 ? true : false;
				//else
				//{

				__m128 m_work = _mm_cmpeq_ps(m_m128, param_reg.m_m128);
				if ( _mm_movemask_ps(m_work) == 0xf )
					return true;
				else
					return false;

				//}
			}

			bool operator != (const xmm_register &param_reg)
			{
				//return _mm_cmpneq_ps(m_m128, param_reg.m_m128) != 0 ? true : false;
				
				__m128 m_work = _mm_cmpneq_ps(m_m128, param_reg.m_m128);
				if ( _mm_movemask_ps(m_work) )
					return true;
				else
					return false;
			}

			////

			//	<
			xmm_register<bool,_PERMIT_SIMD>
				operator < (const xmm_register &param_reg)
			{
				xmm_register r;
				r.m_m128 = _mm_cmplt_ps(m_m128, param_reg.m_m128);
				return r;
			}

			//	<=
			xmm_register<bool,_PERMIT_SIMD>
				operator <= (const xmm_register &param_reg)
			{
				xmm_register r;
				r.m_m128 = _mm_cmple_ps(m_m128, param_reg.m_m128);
				return r;
			}

			//	>
			xmm_register<bool,_PERMIT_SIMD>
				operator > (const xmm_register &param_reg)
			{
				xmm_register r;
				r.m_m128 = _mm_cmpgt_ps(m_m128, param_reg.m_m128);
				return r;
			}

			//	>=
			xmm_register<bool,_PERMIT_SIMD>
				operator >= (const xmm_register &param_reg)
			{
				xmm_register r;
				r.m_m128 = _mm_cmpge_ps(m_m128, param_reg.m_m128);
				return r;
			}

			////

			//	! (this < param_reg)
			xmm_register<bool,_PERMIT_SIMD>
				not_lt (const xmm_register &param_reg)
			{
				xmm_register r;
				r.m_m128 = _mm_cmpnlt_ps(m_m128, param_reg.m_m128);
				return r;
			}

			//	! (this <= param_reg)
			xmm_register<bool,_PERMIT_SIMD>
				not_lteq (const xmm_register &param_reg)
			{
				xmm_register r;
				r.m_m128 = _mm_cmpnle_ps(m_m128, param_reg.m_m128);
				return r;
			}

			//	! (this > param_reg)
			xmm_register<bool,_PERMIT_SIMD>
				not_gt (const xmm_register &param_reg)
			{
				xmm_register r;
				r.m_m128 = _mm_cmpngt_ps(m_m128, param_reg.m_m128);
				return r;
			}

			//	! (this >= param_reg)
			xmm_register<bool,_PERMIT_SIMD>
				not_gteq (const xmm_register &param_reg)
			{
				xmm_register r;
				r.m_m128 = _mm_cmpnge_ps(m_m128, param_reg.m_m128);
				return r;
			}

			/////////////////////////////////////////////////////////

			//	rbgZîEEEHj
			xmm_register operator & (const xmm_register &param_reg){
				xmm_register r;
				r.m_m128 = _mm_and_ps(m_m128, param_reg.m_m128);
				return r;
			}

			xmm_register& operator &= (const xmm_register &param_reg){
				m_m128 = _mm_and_ps(m_m128, param_reg.m_m128);
				return *this;
			}

			xmm_register operator | (const xmm_register &param_reg){
				xmm_register r;
				r.m_m128 = _mm_or_ps(m_m128, param_reg.m_m128);
				return r;
			}

			xmm_register& operator |= (const xmm_register &param_reg){
				m_m128 = _mm_or_ps(m_m128, param_reg.m_m128);
				return *this;
			}

			//	XOR
			xmm_register operator ^ (const xmm_register &param_reg){
				xmm_register r;
				r.m_m128 = _mm_xor_ps(m_m128, param_reg.m_m128);
				return r;
			}

			xmm_register& operator ^= (const xmm_register &param_reg){
				m_m128 = _mm_xor_ps(m_m128, param_reg.m_m128);
				return *this;
			}

			//	AndNot
			xmm_register andnot (const xmm_register &param_reg){
				xmm_register r;
				r.m_m128 = _mm_andnot_ps(m_m128, param_reg.m_m128);
				return r;
			}

			////////////////////////////////////////////////////////////////////

			//	Ȗ

#undef min
#undef max
			//	4lꂼɂāAقg܂
			xmm_register min(const xmm_register &param_reg){
				xmm_register r;
				r.m_m128 = _mm_min_ps(m_m128, param_reg.m_m128);
				return r;
			}

			//	4lꂼɂāA傫قg܂
			xmm_register max(const xmm_register &param_reg){
				xmm_register r;
				r.m_m128 = _mm_max_ps(m_m128, param_reg.m_m128);
				return r;
			}

			//	4lꂼ̕߂܂
			xmm_register sqrt(const xmm_register &param_reg){
				xmm_register r;
				r.m_m128 = _mm_sqrt_ps(m_m128, param_reg.m_m128);
				return r;
			}

			//	4lꂼ̋̕t߂܂
			xmm_register rsqrt(const xmm_register &param_reg){
				xmm_register r;
				r.m_m128 = _mm_rsqrt_ps(m_m128, param_reg.m_m128);
				return r;
			}

			//	4lꂼ̋t߂܂
			xmm_register reciprocal(const xmm_register &param_reg){
				xmm_register r;
				r.m_m128 = _mm_rcp_ps(m_m128, param_reg.m_m128);
				return r;
			}

			//	1,3̒lZA2,3̒lZ܂
			xmm_register sub13add24(const xmm_register &param_reg){
				xmm_register r;
				if ( _PERMIT_SIMD >= ROAST_SIMD_TYPE_SSE3 && _PERMIT_SIMD <= ROAST_SIMD_TYPE_SSE_END )
				{
					r.m_m128 = _mm_addsub_ps(m_m128, param_reg.m_m128);
				}
				return r;
			}
		};

		/*************************************************************************/

	}
}

#endif//__SFJP_OPENMGL_roast_simd_float_xmm_register_HPP__
