/*
 * Decompiled with CFR 0.152.
 */
package org.springmodules.validation.valang.functions;

import org.springmodules.validation.util.date.DateParseException;
import org.springmodules.validation.util.date.DateParser;
import org.springmodules.validation.valang.functions.Function;

public class DateLiteralFunction
implements Function {
    private String value = null;
    private DateParser dateParser = null;
    private int line = 0;
    private int column = 0;

    public DateLiteralFunction(String value, DateParser dateParser, int line, int column) {
        this.setValue(value);
        this.setDateParser(dateParser);
        this.setLine(line);
        this.setColumn(column);
    }

    private void setValue(String value) {
        if (value == null) {
            throw new IllegalArgumentException("Value parameter must not be null!");
        }
        this.value = value;
    }

    private String getValue() {
        return this.value;
    }

    private void setDateParser(DateParser dateParser) {
        if (dateParser == null) {
            throw new IllegalArgumentException("Date parser argument should not be null!");
        }
        this.dateParser = dateParser;
    }

    private DateParser getDateParser() {
        return this.dateParser;
    }

    private void setLine(int line) {
        this.line = line;
    }

    private int getLine() {
        return this.line;
    }

    private void setColumn(int column) {
        this.column = column;
    }

    private int getColumn() {
        return this.column;
    }

    public Object getResult(Object target) {
        try {
            return this.getDateParser().parse(this.getValue());
        }
        catch (DateParseException e) {
            throw new RuntimeException("Could not parse date [" + this.getValue() + "] at line " + this.getLine() + ", column " + this.getColumn() + ".");
        }
    }
}

