/*
 * Decompiled with CFR 0.152.
 */
package org.aspectj.weaver.bcel;

import java.util.Iterator;
import java.util.List;
import org.aspectj.apache.bcel.classfile.annotation.AnnotationGen;
import org.aspectj.apache.bcel.classfile.annotation.ElementNameValuePairGen;
import org.aspectj.apache.bcel.classfile.annotation.EnumElementValueGen;
import org.aspectj.apache.bcel.generic.InstructionFactory;
import org.aspectj.apache.bcel.generic.InstructionList;
import org.aspectj.apache.bcel.generic.Type;
import org.aspectj.weaver.AnnotationAJ;
import org.aspectj.weaver.Member;
import org.aspectj.weaver.ResolvedMember;
import org.aspectj.weaver.ResolvedType;
import org.aspectj.weaver.Shadow;
import org.aspectj.weaver.UnresolvedType;
import org.aspectj.weaver.bcel.AnnotationAccessVar;
import org.aspectj.weaver.bcel.BcelAnnotation;
import org.aspectj.weaver.bcel.BcelVar;

class AnnotationAccessFieldVar
extends BcelVar {
    private AnnotationAccessVar annoAccessor;
    private ResolvedType annoFieldOfInterest;

    public AnnotationAccessFieldVar(AnnotationAccessVar aav, ResolvedType annoFieldOfInterest) {
        super(annoFieldOfInterest, 0);
        this.annoAccessor = aav;
        this.annoFieldOfInterest = annoFieldOfInterest;
    }

    public void appendLoadAndConvert(InstructionList il, InstructionFactory fact, ResolvedType toType) {
        if (this.annoAccessor.getKind() != Shadow.MethodExecution) {
            return;
        }
        String annotationOfInterestSignature = this.annoAccessor.getType().getSignature();
        Member holder = this.annoAccessor.getMember();
        AnnotationAJ[] annos = holder.getAnnotations();
        for (int i = 0; i < annos.length; ++i) {
            AnnotationGen annotation = ((BcelAnnotation)annos[i]).getBcelAnnotation();
            if (!annotation.getTypeSignature().equals(annotationOfInterestSignature)) continue;
            List vals = annotation.getValues();
            boolean doneAndDusted = false;
            Iterator iterator = vals.iterator();
            while (iterator.hasNext()) {
                ElementNameValuePairGen object = (ElementNameValuePairGen)iterator.next();
                EnumElementValueGen v = (EnumElementValueGen)object.getValue();
                String s = v.getEnumTypeString();
                ResolvedType rt = toType.getWorld().resolve(UnresolvedType.forSignature(s));
                if (!rt.equals(toType)) continue;
                il.append(fact.createGetStatic(rt.getName(), v.getEnumValueString(), Type.getType(rt.getSignature())));
                doneAndDusted = true;
            }
            if (doneAndDusted) continue;
            ResolvedMember[] annotationFields = toType.getWorld().resolve(UnresolvedType.forSignature(annotation.getTypeSignature())).getDeclaredMethods();
            for (int ii = 0; ii < annotationFields.length; ++ii) {
                if (!annotationFields[ii].getType().equals(this.annoFieldOfInterest)) continue;
                String dvalue = annotationFields[ii].getAnnotationDefaultValue();
                String typename = dvalue.substring(0, dvalue.lastIndexOf(59) + 1);
                String field = dvalue.substring(dvalue.lastIndexOf(59) + 1);
                ResolvedType rt = toType.getWorld().resolve(UnresolvedType.forSignature(typename));
                il.append(fact.createGetStatic(rt.getName(), field, Type.getType(rt.getSignature())));
            }
        }
    }

    public String toString() {
        return super.toString();
    }
}

