/*
 * Decompiled with CFR 0.152.
 */
package ch.qos.logback.core.rolling;

import ch.qos.logback.core.rolling.TimeBasedFileNamingAndTriggeringPolicy;
import ch.qos.logback.core.rolling.TimeBasedRollingPolicy;
import ch.qos.logback.core.rolling.helper.ArchiveRemover;
import ch.qos.logback.core.rolling.helper.DateTokenConverter;
import ch.qos.logback.core.rolling.helper.RollingCalendar;
import ch.qos.logback.core.spi.ContextAwareBase;
import java.util.Date;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class TimeBasedFileNamingAndTriggeringPolicyBase<E>
extends ContextAwareBase
implements TimeBasedFileNamingAndTriggeringPolicy<E> {
    protected TimeBasedRollingPolicy<E> tbrp;
    protected ArchiveRemover archiveRemover = null;
    protected String elapsedPeriodsFileName;
    protected RollingCalendar rc;
    protected long currentTime;
    protected boolean isTimeForced = false;
    protected Date dateInCurrentPeriod = null;
    protected long nextCheck;
    protected boolean started = false;

    @Override
    public boolean isStarted() {
        return this.started;
    }

    @Override
    public void start() {
        DateTokenConverter dtc = this.tbrp.fileNamePattern.getDateTokenConverter();
        if (dtc == null) {
            throw new IllegalStateException("FileNamePattern [" + this.tbrp.fileNamePattern.getPattern() + "] does not contain a valid DateToken");
        }
        this.rc = new RollingCalendar();
        this.rc.init(dtc.getDatePattern());
        this.addInfo("The date pattern is '" + dtc.getDatePattern() + "' from file name pattern '" + this.tbrp.fileNamePattern.getPattern() + "'.");
        this.rc.printPeriodicity(this);
        if (this.dateInCurrentPeriod == null) {
            this.dateInCurrentPeriod = new Date();
            this.updateDateInCurrentPeriod(this.getCurrentTime());
        }
        this.computeNextCheck();
    }

    @Override
    public void stop() {
        this.started = false;
    }

    protected void computeNextCheck() {
        this.nextCheck = this.rc.getNextTriggeringMillis(this.dateInCurrentPeriod);
    }

    @Override
    public void setDateInCurrentPeriod(Date _dateInCurrentPeriod) {
        this.dateInCurrentPeriod = _dateInCurrentPeriod;
    }

    public Date getDateInCurrentPeriod() {
        return this.dateInCurrentPeriod;
    }

    @Override
    public String getElapsedPeriodsFileName() {
        return this.elapsedPeriodsFileName;
    }

    @Override
    public String getCurrentPeriodsFileNameWithoutCompressionSuffix() {
        return this.tbrp.fileNamePatternWCS.convert(this.dateInCurrentPeriod);
    }

    protected void updateDateInCurrentPeriod(long now) {
        this.dateInCurrentPeriod.setTime(now);
    }

    @Override
    public void setCurrentTime(long timeInMillis) {
        this.currentTime = timeInMillis;
        this.isTimeForced = true;
    }

    @Override
    public long getCurrentTime() {
        if (this.isTimeForced) {
            return this.currentTime;
        }
        return System.currentTimeMillis();
    }

    @Override
    public void setTimeBasedRollingPolicy(TimeBasedRollingPolicy<E> _tbrp) {
        this.tbrp = _tbrp;
    }

    @Override
    public ArchiveRemover getArchiveRemover() {
        return this.archiveRemover;
    }
}

