#ifndef QTFREESCROLL_H
#define QTFREESCROLL_H

#include <QPushButton>
#include "ui_QtFreeScroll.h"

class QtFreeScroll : public QPushButton
{
	Q_OBJECT

signals:
	void onScroll(int step);
	void onReset(void);

public:
	QtFreeScroll(QWidget *parent = 0);
	~QtFreeScroll();

protected:
	virtual void mousePressEvent(QMouseEvent *e);
	virtual void mouseMoveEvent(QMouseEvent *e);

private:
	Ui::QtFreeScroll ui;

	QPoint iniPos;
	QPoint iniMousePos;
	double roundRest;
};

#endif // QTFREESCROLL_H
