#pragma once

#include <C2/gl/GlContextShare.h>

#include "View3D.h"
#include "View2D.h"
#include "ViewConfigDlg.h"
#include "CrossSectionConfigDlg.h"
#include "DlgAssociationEdit.h"
#include "GLWidgetList.h"
#include "FullScreenPanel.h"

#include "GuiConfig.h"
#include "GuiDataBinder.h"

#include <LibQtGeoViewerCore/SceneMain.h>
#include <LibQtGeoViewerCore/Image/SampleTextureBuilder.h>
#include <LibQtGeoViewerCore/GeomFileFormat.h>

#include <QMainWindow>
#include "ui_FormMain.h"

#include <QColorDialog>
#include <QPrinter>
#include <QString>


class QTableWidget;
class FormCustomShader;
class FormPyScript;
class MatcapSelectDlg;
class EnvmapSelectDlg;
class MaterialPresetDlg;


class FormMain : public QMainWindow
{
	Q_OBJECT

public:
	FormMain(QWidget *parent = 0);
	~FormMain();

	bool OpenGeomFileToLast(const QString& path);

	void updateView_All(void);
	void updateView_2D(void);
	void updateView_3D(void);

	void RefreshObjectSelectState(void);

	void DeleteSelectedObject();

	void ClearAllObjects(void);

	void RebuildAllGLBuf(void);

	void ShowObjectOnlySelected(void);

	bool IsAutUVFit(void) const;

	void ResetSequenceSliderRange(void);

	QString GetFilePathFromOpenDlg(const QString& title, const QString& filter);
	QString GetFilePathFromSaveDlg(const QString& title, const QString& filter);
	QString GetSupportedImageFilePathFromDlg(const QString& title);

protected:
	virtual void closeEvent(QCloseEvent *e);

	virtual void keyPressEvent(QKeyEvent *e);

	virtual bool eventFilter(QObject * filterobj, QEvent * filterevt);

private:
	void SetContextShare(void);

	void HideFeatures(void);

	void InitializeEventFilter(void);
	void InitializeGLView(void);
	void InitializeStatusBar(void);
	void InitializeCoordinateCombobox(void);
	void Initialize2DViewSrcCombobox(void);
	void InitializeSubDlg(void);
	void InitializeAnimation(void);
	void SaveConfig(void);

	void LoadLastWinPos(void);
	void SaveWinPos(void);

	void InitializeFromConfigFiles(void);
	void LoadDefaultConfig(void);

	bool InitializeConfig(QString path);
	void SaveConfigFile(QString path);

	void InitializeMenu(void);
	void InitContextMenu(void);
	void ProcArguments(void);

	bool IsCameraFile(const QString& path) const;

	void DropTextureFile(const QString& path, const QPoint& pos);

	bool IsSupportedTextureExt(const QString& path) const;

	void CenteringSplitter(void);

	void SyncViewSettingsFromGUI(void);
	void SyncShaderSettingsToGUI(void);

	QAction* GetMenuFromShader(ShaderType type);

	void UpdateViewTypeFromMenu(void);

	bool SaveWindowLayout(const QString& filepath);
	bool LoadWindowLayout(const QString& filepath);

	void ApplyGeomStateFromGUI(void);
	void ApplyGeomStateDataoToGUI(void);

	void ChangeShaderMenuMain(ShaderType type);
	void ChangePostprocMode(PostProcType type);

	void CreateSampleTextureMain(SampleTextureBuilder::TextureType tex_type);

	void OnChangedSelectedMaterial(void);
	void SetMatShininessSliderPos(float shininess);

	void RebuildMatList(void);

	void PrintImage(bool WithPreview);

	void UpdateAnimState(void);
	bool IsEnableAnimation(void);
	void StepSequence(int step);
	bool IsLastSequence(void);
	bool IsTopSequence(void);

	void LoadEnvMap(QString& path);

	void ShowAndActivateAndRaise(QDockWidget* widget);

	bool OnDropFile_editEnvMap(QEvent * filterevt);
	bool OnDropFile_editMatcap(QEvent * filterevt);
	bool OnDropFile_editMatcapEachMat(QEvent * filterevt);
	bool OnDropFile_editCurrentTexName(QEvent * filterevt);
	bool OnDropFile_editCurrentMatNormalMap(QEvent * filterevt);
	bool AcceptDropFilterIfUrl(QEvent * filterevt);
	QString GetFirstLoadableImagePathFromDragEvent(QEvent* filterevt);
	bool IsResetSceneOnBeforeLoadFile(void) const;

	bool colorAmbient_OnButtonDown(QEvent * filterevt);
	bool colorEmission_OnButtonDown(QEvent * filterevt);
	bool colorDiffuse_OnButtonDown(QEvent * filterevt);
	bool colorSpecular_OnButtonDown(QEvent * filterevt);

	void InitDataBinding(void);
	void InitializeVisiblStateMenu(void);
	void InitializeUVStateMenu(void);
	void InitializeTexStateMenu(void);
	void InitializeSceneStateMenu(void);
	void InitializeGeomStateMenu(void);
	void InitializeCursorMenu(void);

	void AddGeomStateAction(const QAction* action);

	void UpdateCameraStatus(void);

	float GetSliderNormalizedPos(const QSlider* slider) const;

	QString GetNextDefaultPathForFileDlg(void);

	void SetColorPalleteBG(QWidget* w, QColor col);
	void SetWidgetColor(QWidget* w, QColor col);
	void SetWidgetColor(QWidget* w, QColor col, QColor col_border);
	void SetSelectedMaterialColor(QColor col);

	void AddRecentFile(const QString& path);
	void CreateRecentFilesMenu(const std::vector<QString>& path);
	void CreateRecentFilesFromMenu(std::vector<QString>& path);

	void ResetHoleRange(void);

	void ChangeMatlemColor(QWidget* col_widget);

	void FocusNextSubDlg(void);

	void LoadCurSelMatTexture(TextureType type);
	void LoadCurSelMatTexture(TextureType type, QString filepath);
	void ReleaseCurSelTexture(TextureType type);
	void LoadMatcapImageForCurrentMat(QString& path);
	void LoadMatcapImage(QString& path);

	void UpdateSequence(void);

	void UpdateLightPowerText(void);

	void SyncTexConfigToGUI(bool silent);
	void SyncTexConfigToData(void);
	void SetActioncheck(QAction* a, bool silent, bool check);

	void MulTexScaleMain(double s);
	void SetTextSilent(QLineEdit* edit, const QString& text);

private slots:
	virtual void dragEnterEvent(QDragEnterEvent* e);
	virtual void dropEvent(QDropEvent* e);

	void on_actionOpen_triggered();

	void on_actionExit_triggered();

	void actionVisibleStates_Triggered(bool);

	void on_actionWindow_ToolBarView_triggered(bool checked);
	void on_actionToolBar_Options_toggled(bool checked);
	void on_actionToolBar_Operation_toggled(bool checked);

	void on_actionCameraDist_triggered();
	void on_actionCameraFront_triggered();
	void on_actionCameraBack_triggered();
	void on_actionCameraLeft_triggered();
	void on_actionCameraRight_triggered();
	void on_actionCameraTop_triggered();
	void on_actionCameraBottom_triggered();
	void on_actionCameraPers_triggered();
	void on_actionCameraLookCenter_triggered();
	void on_actionCameraLookOrigin_triggered();

	void on_actionWindow_3DView_triggered(bool checked);
	void on_actionWindows_DualView_triggered(bool checked);
	void on_actionWindow_UVView_triggered(bool checked);

	void on_actionWindowMaterialList_triggered();
	void on_actionWindowObjectList_triggered();
	void on_actionWindowCameraList_triggered();
	void on_actionWindowScenePanel_triggered();
	void on_actionCursorPanel_triggered();
	void on_actionIOOptionPanel_triggered();

	void on_listMaterial_currentItemChanged(QListWidgetItem *current, QListWidgetItem *previous);

	virtual void actionGeomStates_Triggered(bool);
	void on_actionGeomClear_triggered();

	void on_actionUVFitView_triggered();

	void on_actionSelObjectDelete_triggered();
	void on_actionShowOnlySelected_triggered();

	void on_actionAddSample_triggered();

	void on_actionShaderDefault_triggered(bool checked);
	void on_actionShaderPhong_triggered(bool checked);
	void on_actionShaderCustom_triggered(bool checked);
	void on_actionNormalColor_triggered(bool checked);
	void on_actionDepthColor_triggered(bool checked);
	void on_actionShadowmap_triggered(bool checked);
	void on_actionEnvmap_triggered(bool checked);
	void on_actionIntegrateShader_triggered(bool checked);
	void on_actionMatcapShader_triggered(bool checked);

	void on_actionUVResetView_triggered();

	void on_actionWireColor_triggered();
	void on_actionFaceColor_triggered();
	void on_actionBackGroundColor_triggered();

	void on_actionWindowOptions_triggered();
	void on_actionWindowCustomShader_triggered();

	void ConfigChangedDlg_ConfigChanged();
	void CrossSectionDlg_ConfigChanged();

	void OnPaintImage(QPrinter *printer);

	void on_actionPrint_triggered();
	void on_actionPrintPreview_triggered();

	void on_actionSaveCamera_triggered();

	void on_actionProjectionOrtho_triggered();
	void on_actionProjectionPers_triggered();

	void CustomShaderDlg_ShaderBuild();

	void OnAnimationTimerUpdated();

	void on_actionRotateCamera_toggled(bool checked);
	void on_actionRotateLight_toggled(bool checked);
	void on_actionAnimation_toggled(bool checked);
	void on_actionAnimationRev_toggled(bool checked);

	void on_actionCrossSectionDlg_triggered();

	void WireOverlayColorChanged(const QColor & color);
	void FaceDiffuseColorChanged(const QColor & color);
	void BGColorChanged(const QColor & color);
	void SelMatColorChanged(const QColor & color);

	void CopyRGB(lgr::color4f& c, const QColor & color);
	void CopyRGBA(lgr::color4f& c, const QColor & color);

	void on_actionSelectNext_triggered();
	void on_actionSelectPrev_triggered();
	void on_actionSwitchVisible_triggered();
	void on_actionHideAll_triggered();
	void on_actionShowAll_triggered();

	void on_actionAddGroundPlane_triggered();

	void on_actionVertexBuilder_triggered();

	void on_actionFullScreen_triggered();

	void on_actionResetConfig_triggered();

	void on_toolLoadEnvMap_clicked();
	void on_buttonReleaseEnvImg_clicked();
	void on_buttonPresetEnvMap_clicked();
	void on_toolLoadMatcap_clicked();
	void on_buttonReleaseMatcap_clicked();
	void on_buttonLoadMatcapPreset_clicked();
	void on_sliderEnvReflection_valueChanged(int value);
	void on_sliderEnvRefract_valueChanged(int value);

	void on_comboCoordinate_currentIndexChanged(int index);

	void on_sliderShadowDarkness_valueChanged(int value);

	void on_actionOpenAppdir_triggered();
	void on_actionOpenConfigDir_triggered();

	void EnvmapDlg_ListSelectChanged();
	void MatcapDlg_ListSelectChanged();

	void on_buttonDecGridAxis_clicked();
	void on_buttonIncGridAxis_clicked();
	void on_buttonResetGridAxis_clicked();

	void View3D_SelectedObjectChanged(int sel_obj, int sel_mesh);
	void View3D_SelectedMatChanged(int sel_idx);
	void View3D_CameraMoved(void);
	void View3D_StatusTipChanged(QString msg);
	void View3D_SequenceStepped(int step);
	void View3D_CursorMoved();

	void on_actionCameraFPSMode_toggled(bool arg1);

	void on_actionResetCursor_triggered();
	void on_actionResetMeasure_triggered();

	void on_actionPyScript_triggered();
	void on_actionConsole_triggered();

	void on_actionClearVertSelect_triggered();

	void on_action_About_triggered();

	void on_action_Association_triggered();

	void on_actionLookDepth_triggered();
	void on_actionLook3DCursor_triggered();

	void on_sliderLightPowerDS_valueChanged(int value);
	void on_buttonResetLightPowerDS_clicked();
	void on_sliderLightPowerA_valueChanged(int value);
	void on_buttonResetLightPowerA_clicked();

	void actionVisibleStatesUV_Triggered(bool);
	void actionVisibleStatesTex_Triggered(bool);
	void actionSceneStates_Toggled(bool);
	void actionCursorMenuStates_Toggled(bool);

	void on_checkHoleAroundCursor_clicked(bool checked);
	void on_checkShowOnlyAroundCursor_toggled(bool checked);

	void on_sliderCursorHoleRange_valueChanged(int value);

	void on_buttonResetCursorHoleRange_clicked();

	void on_actionSaveImageToMydoc_triggered();

	void on_actionPostProcNone_triggered();
	void on_actionPostProcAntialias_triggered();
	void on_actionPostProcBorder_triggered();
	void on_actionPostProcDepthLayerColor_triggered();
	void on_actionPostProcDepthColor_triggered();
	void on_actionPostProcDepthOfField_triggered();

	void on_sliderDOFPint_valueChanged(int value);
	void on_sliderDOFRange_valueChanged(int value);
	void on_buttonResetDOFPint_clicked();
	void on_buttonResetDOFRange_clicked();

	void on_actionAddCrossSectionRecord_triggered();
	void on_actionClearCrossSectionRecord_triggered();

	void on_buttonOpenCurrentMatColorMap_clicked();
	void on_buttonClearCurrentMatColorMap_clicked();
	void on_buttonOpenMatCapEachMaterial_clicked();
	void on_buttonClearMatCapEachMaterial_clicked();
	void on_buttonOpenCurrentMatNormalMap_clicked();
	void on_buttonClearCurrentMatNormalMap_clicked();

	void on_sliderShininess_valueChanged(int value);

	void OnOpenRecent();

	void on_actionReleaseShader_triggered();

	void on_combo2DViewSrcType_currentIndexChanged(int index);

	void on_sliderSequence_valueChanged(int value);

	void on_actionNewStroke_triggered();
	void on_actionClearStroke_triggered();

	void on_butonAnimationRev_toggled(bool checked);
	void on_butonAnimationFwd_toggled(bool checked);

	void on_buttonMatPreset_clicked();
	void MatPresetDlg_OnMatChanged();

	void on_actionTextureMipmap_toggled(bool b);
	void on_actionTextureLinear_toggled(bool b);
	void on_actionTextureNearest_toggled(bool b);

	void on_checkEnableIndexRange_toggled(bool checked);
	void on_editIndexLimitOffset_textChanged(const QString &arg1);
	void on_editIndexLimitLen_textChanged(const QString &arg1);

	void on_fscrollIndexLimitOffset_onScroll(int step);
	void on_fscrollIndexLimitOffset_onReset();
	void on_fscrollIndexLimitLen_onScroll(int step);
	void on_fscrollIndexLimitLen_onReset();

	void on_buttonTextureScaleDiv10_clicked();
	void on_buttonTextureScaleMul10_clicked();
	void on_fscrollTextureScale_onScroll(int step);
	void on_fscrollTextureScale_onReset();
	void on_editTextureScale_textChanged(const QString &arg1);

	void on_sliderMatcapRate_valueChanged(int value);

private:
	Ui::FormMainClass ui;

	ViewConfigDlg          m_ViewConfigDlg;
	CrossSectionConfigDlg  m_CrossSectionDlg;
	FullScreenPanel        m_FullscreenPanel;
	DlgAssociationEdit     m_AssociationDlg;

	FormCustomShader*      m_CustomShaderDlg;
	FormPyScript*          m_PyScriptDlg;
	MatcapSelectDlg*       m_MatcapDlg;
	EnvmapSelectDlg*       m_EnvmapDlg;
	MaterialPresetDlg*     m_MatPresetDlg;

	QColorDialog m_WireColorSelDlg;
	QColorDialog m_DiffuseColorSelDlg;
	QColorDialog m_BGColorSelDlg;

	QActionGroup* m_AGroup_Window;
	QActionGroup* m_AGroup_Shader;
	QActionGroup* m_AGroup_PProc;
	QActionGroup* m_AGroup_Texture;

	QColorDialog m_SelMatColorSelDlg;
	QWidget*     m_SelMatColorWidget;

	QLabel* m_StatusBar0;
	QLabel* m_StatusBar1;

	DataBinderMap m_Binder_ViewConfig;
	DataBinderMap m_Binder_UVConfig;
	DataBinderMap m_Binder_TexConfig;
	DataBinderMap m_Binder_Scene;
	DataBinderMap m_Binder_Cursor;

	QDockWidget* m_LastFocusedDockDlg;

public:
	SceneMain m_Scene;

	View3D m_View3d;
	View2D m_View2d;

private:
	QString m_LastFileDialogDir;

	lib_gl::GlContextShare m_ContextShare;
	GLWidgetList m_Widgets;

	QTimer m_AnimationTimer;

	bool m_EnableAllFeatures;

	QRect m_InitRect;
};
