#include "stdafx.h"
#include "SceneNode.h"

#include "Skining/Bone.h"



namespace geom
{


lm::matrix4f SceneNode::GetFrameTransform(int frame) const
{
	// `t[ԍw肳ꂽꍇ̓m[h̃gXtH[Ԃ
	if (frame < 0)
		return m_Transform;
	if (!m_SeqTrans.HasKey())
		return m_Transform;

	return m_SeqTrans.GetTransform(frame);
}

int SceneNode::GetKeyframeMax(void) const
{
	int child_max = 0;
	for (const SceneNode& n : m_Children)
	{
		child_max = (std::max)(child_max, n.GetKeyframeMax());
	}

	return (std::max)(child_max, m_SeqTrans.GetNumframes());
}


}
