#include "StdAfx.h"
#include "OrthoConvert.h"



lm::vec3f OrthoConvert::ToLocal(const lm::vec3f& ex, const lm::vec3f& ey, const lm::vec3f& ez, const lm::vec3f& global)
{
	lm::vec3f l;
	l.x = ex.x * global.x + ex.y * global.y + ex.z * global.z;
	l.y = ey.x * global.x + ey.y * global.y + ey.z * global.z;
	l.z = ez.x * global.x + ez.y * global.y + ez.z * global.z;
	return l;
}

lm::vec3f OrthoConvert::ToGlobal(const lm::vec3f& ex, const lm::vec3f& ey, const lm::vec3f& ez, const lm::vec3f& local)
{
	return
		ex * local.x +
		ey * local.y +
		ez * local.z;
}
