#include "stdafx.h"
#include "GeomFileFormat.h"

#include <QFileInfo>



namespace geom
{


GeomFileFormat FormatType::GetGeomFileTypeFromPath(const QString& path)
{
	QString ext = QFileInfo(path).suffix().toLower();
	return GetGeomFileTypeFromFileExt(ext);
}

GeomFileFormat FormatType::GetGeomFileTypeFromFileExt(const QString& ext)
{
	if ( ext == "obj" ) return GeomFileFormat::Obj;
	if ( ext == "stl" ) return GeomFileFormat::Stl;
	if ( ext == "ply" ) return GeomFileFormat::Ply;
	if ( ext == "mqo" ) return GeomFileFormat::Mqo;
	if ( ext == "dae" ) return GeomFileFormat::Collada;
	if ( ext == "pmd" ) return GeomFileFormat::Pmd;
	if ( ext == "x"   ) return GeomFileFormat::XFile;

	return GeomFileFormat::None;
}

bool FormatType::IsGeomFileExt(const QString& path)
{
	return (GetGeomFileTypeFromPath(path) != GeomFileFormat::None);
}


}
