#pragma once

#include "SeqTrans.h"
#include "SceneNode.h"



namespace geom
{


class GeoNodeTree
{
public:
	void Clear(void)
	{
		m_RootNodes.clear();
	}

	int GetKeyframeMax(void) const;

	void TraceNodeTree(void);
	void TraceNodeTreeN(SceneNode* bn);

	bool HasRoot(void) const
	{
		return !m_RootNodes.empty();
	}
	
	SceneNode& GetRoot(void)
	{
		return m_RootNodes.front();
	}
	const SceneNode& GetRoot(void) const
	{
		return m_RootNodes.front();
	}

	void ResetRoot(void)
	{
		m_RootNodes.clear();
		m_RootNodes.resize(1);
	}

private:
	// ŕvf\ł0or1
	boost::ptr_vector<SceneNode> m_RootNodes;
};


}
