﻿using System;
using System.Collections.Generic;
using System.Linq;
using System.Text;
using System.Threading.Tasks;

namespace ChangeExtDefaultApp
{
	class Program
	{
		static void ShowArgs(string[] args)
		{
			string s;
			s = args.Length.ToString() + "\n";
			foreach (string ss in args)
			{
				s += ss + "\n";
			}

			System.Windows.Forms.MessageBox.Show(s);
		}

		static void Main(string[] args)
		{
			//SowArgs(args);
			//return;

			if (args.Length != 2)
			{
				System.Console.WriteLine("ChangeExtDefaultApp [ext] [app_path]");
				return;
			}

			DefaultAppConfig config = new DefaultAppConfig();

			// 拡張子("obj"等)
			string ext = args[0];

			// 実行ファイルパス
			string path = args[1];

			// ファイル形式の分類名("qgv_type_obj"等)
			string typeclass = "qgv_type_" + ext;

			// ファイルの説明("形状ファイル"等)
			string desc = "QtGeoViewer_Geometry";

			// 動詞("open_***"等)
			string verb = "Open_QtGeoViewer";

			// エクスプローラに表示される動詞("**で開く"など)
			string exp_verb = "QtGeoViewerで開く (&Q)";

			config.extension = "." + ext;
			config.commandline = "\"" + path + "\" \"%1\"";
			config.fileType = typeclass;
			config.description = desc;
			config.verb = verb;
			config.verb_description = exp_verb;
			config.iconPath = path;

			ExtDefaultApp a = new ExtDefaultApp();
			a.Execute(config);
		}
	}
}
