#pragma once

#include <QXmlStreamWriter>
#include <QDomNode>


#define QXML_ELEM_FOREACH(NODE,PARENT)\
	for(QDomNode NODE = PARENT.firstChild();\
			!NODE.isNull();\
			NODE = NODE.nextSibling())\
		if(NODE.isElement())


namespace qxe
{


inline void WriteBool(QXmlStreamWriter& xml, const QString& name, bool b)
{
	xml.writeTextElement(name, b ? "True" : "False");
}

inline void WriteText(QXmlStreamWriter& xml, const QString& name, const std::string& s)
{
	xml.writeTextElement(name, s.c_str());
}

inline void WriteInt(QXmlStreamWriter& xml, const QString& name, int i)
{
	xml.writeTextElement(name, QString::number(i));
}


inline bool ReadBool(const QDomNode& n)
{
	return (n.firstChild().nodeValue() == "True");
}

inline std::string ReadText(const QDomNode& n)
{
	return n.firstChild().nodeValue().toLocal8Bit().data();
}

inline int ReadInt(const QDomNode& n)
{
	return n.firstChild().nodeValue().toInt();
}


}
