#pragma once

#include <sstream>
#include <string>


namespace util
{

template<typename STREAM, typename STR_STREAM>
class StreamToStrHelper_T
{
public:
	STREAM& os() { return ss; }

private:
	STR_STREAM ss;
};

typedef StreamToStrHelper_T<std::ostream, std::ostringstream> StreamToStrHelper;
typedef StreamToStrHelper_T<std::wostream, std::wostringstream> StreamToStrHelperW;

}


//! Xg[𕶎ɕϊ
//! ex : { std::string s = STREAM_TO_STR( "value : " << 123 ); }
#define STREAM_TO_STR(STREAM)\
	((std::ostringstream&)(util::StreamToStrHelper().os()<<STREAM)).str()

#define STREAM_TO_WSTR(STREAM)\
	((std::wostringstream&)(util::StreamToStrHelperW().os())<<STREAM)).str()
