#pragma once

#include "Color.h"
#include "RawImage.h"

#include "OpenCVImageConverter.h"


namespace lgr
{


//! OpenCV𗘗p摜t@Co̓NX.
class OpenCVImageIO
{
public:
	template<typename T>
	static bool LoadFile( RawImage< color3<T> >& o_image , const char* filename );

	template<typename T>
	static bool LoadFile( RawImage< color4<T> >& o_image , const char* filename );

	template<typename T>
	static bool LoadAlphaMaskFromFile( RawImage< color4<T> >& o_image , const char* filename );


	template<typename T>
	static bool SaveFile( const RawImage< color3<T> >& i_image , const char* filename );

	template<typename T>
	static bool SaveFile( const RawImage< color4<T> >& i_image , const char* filename );
};


template<typename T> inline
bool OpenCVImageIO::LoadFile( RawImage< color3<T> >& o_image , const char* filename )
{
	o_image.clear();

	IplImage* cv_image = cvLoadImage( filename , CV_LOAD_IMAGE_UNCHANGED );
	if( cv_image == NULL )
		return false;

	OpenCVImageConverter::ConvertImageFromCV( cv_image , o_image );

	cvReleaseImage( &cv_image );

	return true;
}

template<typename T> inline
bool OpenCVImageIO::LoadFile( RawImage< color4<T> >& o_image , const char* filename )
{
	o_image.clear();

	IplImage* cv_image = cvLoadImage( filename , CV_LOAD_IMAGE_UNCHANGED );
	if( cv_image == NULL )
		return false;

	OpenCVImageConverter::ConvertImageFromCV( cv_image , o_image );

	cvReleaseImage( &cv_image );

	return true;
}

template<typename T>
bool OpenCVImageIO::LoadAlphaMaskFromFile( RawImage< color4<T> >& o_image , const char* filename )
{
	IplImage* cv_image = cvLoadImage( filename , CV_LOAD_IMAGE_UNCHANGED );
	if( cv_image == NULL )
		return false;

	bool bConverted = OpenCVImageConverter::ConvertToAlphaMaskFromCV( cv_image , o_image );

	cvReleaseImage( &cv_image );

	return bConverted;
}


template<typename T>
static bool SaveFile( const RawImage< color3<T> >& i_image , const char* filename )
{
}

template<typename T>
static bool SaveFile( const RawImage< color4<T> >& i_image , const char* filename )
{
}


}
