#pragma once

#include "GeometryVBO.h"



namespace lib_geo
{
class BaseMesh;
class BaseFace;
}

namespace geom
{
class FaceGroup;
}

class GeometryVBO;


//! ܂obt@L̂Ȃ, Op`̃Xĝ݂ō\VBOobt@.
//! y͂Ȃ舫.
class GeomVBOTriCache
{
public:
	void Create(lib_geo::BaseMesh& mesh, const geom::FaceGroup& fg);

private:
	size_t GetNumTrianglesFG(lib_geo::BaseMesh& mesh, const geom::FaceGroup& fg) const;

	void ClearReserve(size_t num_triangles, bool enable_normal, bool enable_uv, bool enable_tangent);

	void IncrementTriangleIndex(void);

	void CopyFV(lib_geo::BaseMesh& mesh, lib_geo::BaseFace& f, int i0, int i1, int i2);
	void CopyFN(lib_geo::BaseMesh& mesh, lib_geo::BaseFace& f, int i0, int i1, int i2);
	void CopyFUV(lib_geo::BaseMesh& mesh, lib_geo::BaseFace& f, int i0, int i1, int i2);
	void CopyFT(lib_geo::BaseMesh& mesh, lib_geo::BaseFace& f, int i0, int i1, int i2);

public:
	std::vector<lm::vec3f> verts;
	std::vector<lm::vec3f> norms;
	std::vector<lm::vec3f> tangents;
	std::vector<lm::vec2f> uvs;
	std::vector<GLuint> indexbuf;
	size_t num_triangles;
};

class GeomVBOBuilder
{
public:
	void CreateFromFaceGroup(GeometryVBO* vbo, lib_geo::BaseMesh& mesh, const geom::FaceGroup& fg);
};
