#pragma once

#include <LibQtGeoViewerCore/SceneMain.h>

#include "../../GLUtility/ShadowBuffer.h"



namespace gl
{
class MatcapImage;
}


class ShaderContext
{
public:
	SceneMain* m_Scene;

	ShadowBuffer m_ShadowBuf;
};


class ShaderInterface
{
public:
	ShaderInterface(ShaderContext* context) :
		m_Context(context)
	{
	}

	const ShaderContext* GetContext(void) const;

	virtual const char* GetShaderName(void) = 0;

	virtual void BeginShader(void) = 0;
	virtual void EndShader(void) = 0;

	virtual bool IsRequireShadowBuf(void) const { return false; }

	virtual void SetColorTextureEnabled(bool enabled) {}
	virtual void SetTextureSpecularSeparate(bool enabled) {}

	virtual void SetDublesideEnabled(bool enabled) {}
	virtual void SetLightingEnabled(bool enabled) {}

	virtual void SetNormalTexture(gl::GlTexture* tex_n) {}
	virtual void SetMatcap(gl::MatcapImage* matcap) {}

	virtual void SetFlatShade(bool enable_flat) {}

	virtual GLint GetTangentAttribIndex(void) { return -1; }

protected:
	ShaderContext* m_Context;
};
