#include "stdafx.h"
#include "SampleShapeBuilder.h"

#include <LibGeo/Mesh/BaseMesh.h>
#include <LibGeo/Mesh/BaseMeshGen.h>

#include <LibQtGeoViewerCore/SceneMain.h>



void SampleShapeBuilder::CreateSphere(SceneMain& scene)
{
	GeomObject* geom = scene.CreateNewGeometry();
	MeshBuf* mbuf = geom->CreateNewMeshBuf();
	scene.RefreshObjectIndex();

	lib_geo::BaseMeshGen::GenSphere( mbuf->m_Mesh , 1.0f , 20 , 20 );

	geom->m_Name = "sample_sphere";

	mbuf->CreateTextureBuf(1);

	geom->InitializeBufferCommon();
	scene.UpdateTransform();
}

void SampleShapeBuilder::CreateGroundPlane(SceneMain& scene)
{
	GeomObject* geom = scene.CreateNewGeometry();
	MeshBuf* mbuf = geom->CreateNewMeshBuf();
	scene.RefreshObjectIndex();

	int slice = 32;
	float width = 10.0f;
	lib_geo::BaseMeshGen::GenPlaneZX( mbuf->m_Mesh , width , width , slice , slice );

	geom->m_Name = "ground";

	geom->InitializeBufferCommon();
	scene.UpdateTransform();
}