#include "stdafx.h"
#include "FormPyScript.h"

#include "Python/PyBind.h"

#include "View3D.h"
#include "View2D.h"



FormPyScript::FormPyScript(QWidget *parent)
	: QMainWindow(parent)
{
	ui.setupUi(this);

	ResetToDefaultScript();
}

FormPyScript::~FormPyScript()
{
}


void FormPyScript::on_actionRun_triggered()
{
	QString script = ui.plainTextEdit->document()->toPlainText();
	PyBind bind;
	bind.m_Scene = m_Scene;
	bind.m_View2d = m_View2d;
	bind.m_View3d = m_View3d;
	bind.Run(script);
}

void FormPyScript::on_actionConsole_triggered()
{
	::AllocConsole();
	freopen( "CON", "r", stdin  );
	freopen( "CON", "w", stdout );
}

void FormPyScript::ResetToDefaultScript(void)
{
	QString s;
	s += "def pdir(obj):\n";
	s += "	print(dir(obj))\n";
	s += "\n";
	s += "def pdirl(obj):\n";
	s += "	for s in dir(obj):\n";
	s += "		print(s)\n";
	s += "\n";
	s += "\n";
	s += "print(\"--\")\n";
	s += "\n";
	s += "mesh = obj.m_Mesh\n";
	s += "\n";
	s += "view3d.RepaintParent()\n";
	ui.plainTextEdit->document()->setPlainText(s);
}

void FormPyScript::on_actionReset_triggered()
{
	ResetToDefaultScript();
}
