#include "stdafx.h"
#include "Plyloader.h"

#include <LibGeo/Mesh/PLY/PlyMesh.h>

#include <LibQtGeoViewerCore/SceneMain.h>

#include "../FileUtil.h"



bool PlyLoader::Load(SceneMain& scene, const std::string& filename)
{
	lib_geo::ply::PlyMesh ply_mesh;
	if( !ply_mesh.Load( filename ) )
		return false;

	GeomObject* geom = scene.CreateNewGeometry();
	MeshBuf* mbuf = geom->CreateNewMeshBuf();
	scene.RefreshObjectIndex();

	lib_geo::BaseMesh& mesh_dst = mbuf->m_Mesh;

	ply_mesh.ConvertToBaseMesh(mesh_dst);

	mesh_dst.CreateNormalsEachVerts();
	mesh_dst.UpdateNormal();

	geom->m_Name = FileUtil::GetFileTitle(filename);

	geom->m_FileFormat = GeomFileFormat::Ply;
	geom->m_FilePath = filename;
	geom->InitializeBufferCommon();
	scene.UpdateTransform();

	scene.ReportDoneEditGeometry();

	return true;
}
