#pragma once

#include "../../LibQtGeoViewerCore/GeomObject.h"

#include "GeomFileReader.h"



namespace lib_geo
{

class ObjMesh;

}


class ObjLoader : public GeomFileReader
{
public:
	bool Load(SceneMain& scene, const std::string& filename);

private:
	void OnPostLoadObj(SceneMain& scene, geom::MeshBuf& mbuf, const lib_geo::ObjMesh& obj_mesh);

	void InitTextureFromObjMeshBuf(SceneMain& scene, geom::MeshBuf& mbuf, const lib_geo::ObjMesh& obj_mesh);
	std::string GetTextureNameFromFilePath(const std::string& filepath) const;
};
