#pragma once

#include <LibGeo/Shape.h>


enum class CutAngle
{
	CUT_X_FORE,
	CUT_Y_FORE,
	CUT_Z_FORE,
	CUT_X_REV,
	CUT_Y_REV,
	CUT_Z_REV,
	CUT_FREE,
};


enum class AxisType
{
	None,
	X,
	Y,
	Z,
};


class ClipRange
{
public:
	float GetWidth(void) const
	{
		return t - b;
	}

public:
	float t, b;
};


class CrossSectionConfig
{
public:
	CrossSectionConfig(void);

	void ApplyCutPlaneAxis(bool forCut, const lm::range3f bbox);
	void ApplyCutPlaneAxis(bool forCut, const ClipRange& cr);
	void ApplyCutPlane(bool ForCut, const lm::vec3f& p, const lm::vec3f& n);

	void DisableGLClipPlane(void);

	float GetCurrentAxisCutPos(void) const;

	lm::vec3f GetCutAxis(void) const;

	bool IsCutX(void) const;
	bool IsCutY(void) const;
	bool IsCutZ(void) const;

	bool IsRequireUpdateCS(void) const;

	void GetCutPlane(const lm::range3f& tb, lib_geo::Plane& cutplane) const;

	void SetAxisCut(AxisType axis, bool fore);

	bool IsFreeCut(void) const;
	void SetFreeCut(void);

private:
	AxisType GetCurrentCutAxis(void) const;

	void SetAxisClipPlane(AxisType axis, GLenum plane, bool fore, GLdouble height);
	void SetAxisClipPlaneX(GLenum plane, bool fore, GLdouble height);
	void SetAxisClipPlaneY(GLenum plane, bool fore, GLdouble height);
	void SetAxisClipPlaneZ(GLenum plane, bool fore, GLdouble height);
	void SetGLClipPlane(GLenum plane, const lm::vec3f& n, GLdouble height);

	bool IsCutRev(void) const;

public:
	float m_CutPosX;
	float m_CutPosY;
	float m_CutPosZ;

	bool m_Ribbon;
	float m_RibbonRange;

	bool m_LineCS;
	bool m_MultiColor;

	bool m_ShowCutplane;

	bool m_Enable;
	bool m_EnableConvexHull;
	bool m_EnableShowLength;
	bool m_EnableShowCHLength;
	bool m_EnableCrossSectionGroup;

	bool m_Transparent;

private:
	CutAngle m_CutAngle;
};
