#pragma once

#include "BaseMesh.h"


namespace lib_geo
{


//! BaseMesh@\
class BaseMeshGen
{
public:
	static void GenSphere  ( BaseMesh& mesh , float radius , size_t slice_x , size_t slice_y );
	static void GenCrynder ( BaseMesh& mesh , float radius , float height , size_t slice_x );
	static void GenPipe    ( BaseMesh& mesh , float radius , float height , size_t slice_x );
	static void GenBox     ( BaseMesh& mesh , float width_x , float width_y , float width_z );
	static void GenPlaneXY ( BaseMesh& mesh , float width_x , float width_y , size_t slice_x , size_t slice_y );
	static void GenPlaneYZ ( BaseMesh& mesh , float width_y , float width_z , size_t slice_y , size_t slice_z );
	static void GenPlaneZX ( BaseMesh& mesh , float width_z , float width_x , size_t slice_z , size_t slice_x );
};


}
