#pragma once

#include <vector>
#include <map>

#include <C2/lm/coordinate.h>

#include "ColladaMesh.h"
#include "ColladaNode.h"
#include "ColladaBone.h"



namespace lib_geo
{


class ColladaGeom
{
public:
	bool LoadColladaFile(const char* filename);

	void UpdateVertexFromNodeTransform(void);
	void UpdateVertexFromBoneTransform(void);
	void UpdateVertexFromBoneWeighSkinning(void);

	void UpdateNodeTransmat(void);

private:
	void CreateNodeMap(void);
	void AddNodeMap(ColladaNode* n);

	void SetNodeToGeometryReference(void);
	void SetNodeAndBoneReference(void);

	void InitializeTransform(void);

public:
	std::vector<ColladaMesh>             m_Geoms;
	std::vector<ColladaNode>             m_Nodes;
	std::vector<ColladaBone>             m_Bones;
	std::map<std::string, ColladaNode*>  m_NodeMap;
};


}
