#pragma once

#include <SDL.h>
#include <SDL_Image.h>

#include <vector>
#include <string>

#include <C2/util/stream_util.h>



namespace lib_graph
{


//! SDL_imagegĉ摜t@Cǂݍ. {ꖼt@CΉ.
SDL_Surface* LoadSDLSurface(const char* filename, const char *ext)
{
	std::vector<char> buf;
	if (!util::LoadBufferFromFile(buf, filename))
		return NULL;

	if (buf.empty())
		return NULL;

	SDL_RWops* src = SDL_RWFromMem(&buf[0], (int)buf.size());
	if (!src)
		return NULL;

	// const char* -> char* ւ̕ϊ.

	return IMG_LoadTyped_RW(src, 1, ext);
}

SDL_Surface* LoadSDLSurface(const char* filename)
{
	std::string fname_copy = filename;
	std::string::size_type i = fname_copy.find_last_of('.');
	std::string s = fname_copy.substr(i + 1);

	return LoadSDLSurface(filename, &s[0]);
}


}
