// lib_graph::Material, OpenGL̃Jg}eA̓o͋@\

#pragma once

#include "../graph/Color.h"
#include "../graph/Material.h"

#include <sstream>



namespace lib_gl
{


//! Phong̃}eA. OpenGL
class MaterialSetter
{
public:
	//! w肵ʂɃ}eAKp
	static void SetGL( const lib_graph::Material& i_material , GLenum face_type = GL_FRONT_AND_BACK , bool set_diffuse_to_color = true );

	//! OpenGL̃Jg}eA擾.
	//! GL_FRONT_AND_BACK͎擾łȂ̂Œ
	static void GetGL( lib_graph::Material& i_material , GLenum face_type = GL_FRONT );


	//! w肵ʃ}eAKp
	static void SetGL( const lib_graph::DoublesideMaterial& i_material );

	//! OpenGL̃Jg}eA𗼖ʃ}eAIuWFNgɎ擾.
	static void GetGL( lib_graph::DoublesideMaterial& i_material );
};



// implements

//! w肵ʂɃ}eAKp
//! @param face_type            - }eAKp
//! @param set_diffuse_to_color - trueȂAdiffuseglColorɃZbg
inline void MaterialSetter::SetGL( const lib_graph::Material& i_material , GLenum face_type , bool set_diffuse_to_color )
{
	glMaterialfv( face_type , GL_AMBIENT   , i_material.m_Ambient.v()  );
	glMaterialfv( face_type , GL_DIFFUSE   , i_material.m_Diffuse.v()  );
	glMaterialfv( face_type , GL_SPECULAR  , i_material.m_Specular.v() );
	glMaterialfv( face_type , GL_EMISSION  , i_material.m_Emission.v() );

	static const float MAX_SH = 128.0f;
	float sh = i_material.m_Shininess;
	if (sh > MAX_SH)
	{
		std::ostringstream ss;
		ss << "MaterialSetter::SetGL : modified shininess " << sh << " to " << MAX_SH << std::endl;
		OutputDebugStringA(ss.str().c_str());

		sh = MAX_SH;
	}

	glMaterialfv(face_type, GL_SHININESS, &sh);
	
	if( set_diffuse_to_color )
		glColor4fv( i_material.m_Diffuse.v() );
}

//! OpenGL̃Jg}eA擾.
//! GL_FRONT_AND_BACK͎擾łȂ̂Œ
inline void MaterialSetter::GetGL( lib_graph::Material& i_material , GLenum face_type )
{
	glGetMaterialfv( face_type , GL_AMBIENT   , i_material.m_Ambient.v()  );
	glGetMaterialfv( face_type , GL_DIFFUSE   , i_material.m_Diffuse.v()  );
	glGetMaterialfv( face_type , GL_SPECULAR  , i_material.m_Specular.v() );
	glGetMaterialfv( face_type , GL_EMISSION  , i_material.m_Emission.v() );
	glGetMaterialfv( face_type , GL_SHININESS , &i_material.m_Shininess   );
}

//! w肵ʃ}eAKp
inline void MaterialSetter::SetGL( const lib_graph::DoublesideMaterial& i_material )
{
	SetGL( i_material.m_FrontMaterial , GL_FRONT , false );
	SetGL( i_material.m_BackMaterial  , GL_BACK  , false );
}

//! OpenGL̃Jg}eA𗼖ʃ}eAIuWFNgɎ擾.
inline void MaterialSetter::GetGL( lib_graph::DoublesideMaterial& i_material )
{
	GetGL( i_material.m_FrontMaterial , GL_FRONT );
	GetGL( i_material.m_BackMaterial  , GL_BACK  );
}


}
