
/*
*************************************************************************************************

ʕ`p̃r[|[g, eȂǂ𐧌䂷NX

*************************************************************************************************
*/


#pragma once


#include "Viewport.h"

#include <C2/lm/vector3.h>

#include "GlInclude.h"


namespace lib_gl
{


//! 2D`p̓es񐧌
//! glutSolidSphere(100,32,32)Ŕa100sNZ̉~\悤Ȑݒ
//! ōs.
class FlatView
{
public:
	FlatView(void)
	{
		m_Origin.set_zero();
		m_Zoom = 1.0f;
	}

	void SetGLLookAt(void);
	void SetGLProjection(void);
	void SetGLLookAtProjection(void);

	lm::vec3f GetViewCenter(void) const;


public:
	lm::vec3f           m_Origin;    //!< r[̌_()
	double              m_Zoom;      //!< _ÕY[
	lib_gl::Viewport    m_Viewport;  //<! _Or[|[g
};



inline void FlatView::SetGLLookAt(void)
{
	// _
	double px = m_Origin.x;
	double py = m_Origin.y;
	double pz = 1.0;
	// _
	double vx = m_Origin.x;
	double vy = m_Origin.y;
	double vz = 0.0;
	// 
	double ox = 0.0;
	double oy = 1.0;
	double oz = 0.0;

	gluLookAt( px , py , pz , vx , vy , vz , ox , oy , oz );
}

inline void FlatView::SetGLProjection(void)
{
	GLdouble w = (GLdouble)m_Viewport.Width  * m_Zoom;
	GLdouble h = (GLdouble)m_Viewport.Height * m_Zoom;
	glOrtho( 0.0 , w , 0.0 , h , 0.0 , 2.0 );
}

inline void FlatView::SetGLLookAtProjection(void)
{
	glMatrixMode(GL_PROJECTION);
	glLoadIdentity();
	SetGLProjection();

	glMatrixMode(GL_MODELVIEW);
	glLoadIdentity();
	SetGLLookAt();
}

inline lm::vec3f FlatView::GetViewCenter(void) const
{
	lm::vec3f center = m_Origin;
	center.x += (float)m_Viewport.Width  * 0.5f * m_Zoom;
	center.y += (float)m_Viewport.Height * 0.5f * m_Zoom;
	return center;
}


}
