#pragma once

#include "../LibQtGeoViewerCore/GeomObject.h"
#include "../LibQtGeoViewerCore/SceneMain.h"



class CrossSectionRender
{
public:
	CrossSectionRender(SceneMain* scene) :
		m_Scene(scene)
	{
	}

	void DrawAllGeomCsLengthInfo(std::vector<geom::MeshBuf*>& meshes);
	void DrawAllGeomCsConvexHull(std::vector<geom::MeshBuf*>& meshes);

private:
	void DrawCsLengthInfo(const lib_geo::CrossSection& cs);
	void DrawCsConvexHull(const lib_geo::CrossSection& cs);
	void DrawCrossSectinPath(const lib_geo::CrossSection& cs);

private:
	SceneMain* m_Scene;
};

