#pragma once

#include <C2/lm/vector3.h>


namespace geom
{


class SkinWeight
{
public:
	SkinWeight(void)
	{
		Val = 0;
	}

	void Add(float weight, const lm::vec3f& pos)
	{
		Val += weight;
		Pos += pos * weight;
	}

	lm::vec3f GetAvg(void) const
	{
		return Pos / Val;
	}

public:
	float Val;
	lm::vec3f Pos;
};


}
